/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeInstancePatchStatesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeInstancePatchStatesResponse.Builder, DescribeInstancePatchStatesResponse> {
    private final List<InstancePatchState> instancePatchStates;

    private final String nextToken;

    private DescribeInstancePatchStatesResponse(BuilderImpl builder) {
        this.instancePatchStates = builder.instancePatchStates;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The high-level patch state for the requested instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The high-level patch state for the requested instances.
     */
    public List<InstancePatchState> instancePatchStates() {
        return instancePatchStates;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instancePatchStates() == null) ? 0 : instancePatchStates().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancePatchStatesResponse)) {
            return false;
        }
        DescribeInstancePatchStatesResponse other = (DescribeInstancePatchStatesResponse) obj;
        if (other.instancePatchStates() == null ^ this.instancePatchStates() == null) {
            return false;
        }
        if (other.instancePatchStates() != null && !other.instancePatchStates().equals(this.instancePatchStates())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instancePatchStates() != null) {
            sb.append("InstancePatchStates: ").append(instancePatchStates()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstancePatchStates":
            return Optional.of(clazz.cast(instancePatchStates()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeInstancePatchStatesResponse> {
        /**
         * <p>
         * The high-level patch state for the requested instances.
         * </p>
         * 
         * @param instancePatchStates
         *        The high-level patch state for the requested instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancePatchStates(Collection<InstancePatchState> instancePatchStates);

        /**
         * <p>
         * The high-level patch state for the requested instances.
         * </p>
         * 
         * @param instancePatchStates
         *        The high-level patch state for the requested instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancePatchStates(InstancePatchState... instancePatchStates);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<InstancePatchState> instancePatchStates;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancePatchStatesResponse model) {
            instancePatchStates(model.instancePatchStates);
            nextToken(model.nextToken);
        }

        public final Collection<InstancePatchState.Builder> getInstancePatchStates() {
            return instancePatchStates != null ? instancePatchStates.stream().map(InstancePatchState::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instancePatchStates(Collection<InstancePatchState> instancePatchStates) {
            this.instancePatchStates = InstancePatchStateListCopier.copy(instancePatchStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancePatchStates(InstancePatchState... instancePatchStates) {
            instancePatchStates(Arrays.asList(instancePatchStates));
            return this;
        }

        public final void setInstancePatchStates(Collection<InstancePatchState.BuilderImpl> instancePatchStates) {
            this.instancePatchStates = InstancePatchStateListCopier.copyFromBuilder(instancePatchStates);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstancePatchStatesResponse build() {
            return new DescribeInstancePatchStatesResponse(this);
        }
    }
}
