/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.ssm.transform.DocumentDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an SSM document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DocumentDescription implements StructuredPojo, ToCopyableBuilder<DocumentDescription.Builder, DocumentDescription> {
    private final String sha1;

    private final String hash;

    private final String hashType;

    private final String name;

    private final String owner;

    private final Instant createdDate;

    private final String status;

    private final String documentVersion;

    private final String description;

    private final List<DocumentParameter> parameters;

    private final List<String> platformTypes;

    private final String documentType;

    private final String schemaVersion;

    private final String latestVersion;

    private final String defaultVersion;

    private DocumentDescription(BuilderImpl builder) {
        this.sha1 = builder.sha1;
        this.hash = builder.hash;
        this.hashType = builder.hashType;
        this.name = builder.name;
        this.owner = builder.owner;
        this.createdDate = builder.createdDate;
        this.status = builder.status;
        this.documentVersion = builder.documentVersion;
        this.description = builder.description;
        this.parameters = builder.parameters;
        this.platformTypes = builder.platformTypes;
        this.documentType = builder.documentType;
        this.schemaVersion = builder.schemaVersion;
        this.latestVersion = builder.latestVersion;
        this.defaultVersion = builder.defaultVersion;
    }

    /**
     * <p>
     * The SHA1 hash of the document, which you can use for verification purposes.
     * </p>
     * 
     * @return The SHA1 hash of the document, which you can use for verification purposes.
     */
    public String sha1() {
        return sha1;
    }

    /**
     * <p>
     * The Sha256 or Sha1 hash created by the system when the document was created.
     * </p>
     * <note>
     * <p>
     * Sha1 hashes have been deprecated.
     * </p>
     * </note>
     * 
     * @return The Sha256 or Sha1 hash created by the system when the document was created. </p> <note>
     *         <p>
     *         Sha1 hashes have been deprecated.
     *         </p>
     */
    public String hash() {
        return hash;
    }

    /**
     * <p>
     * Sha256 or Sha1.
     * </p>
     * <note>
     * <p>
     * Sha1 hashes have been deprecated.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hashType} will
     * return {@link DocumentHashType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hashTypeString}.
     * </p>
     * 
     * @return Sha256 or Sha1.</p> <note>
     *         <p>
     *         Sha1 hashes have been deprecated.
     *         </p>
     * @see DocumentHashType
     */
    public DocumentHashType hashType() {
        return DocumentHashType.fromValue(hashType);
    }

    /**
     * <p>
     * Sha256 or Sha1.
     * </p>
     * <note>
     * <p>
     * Sha1 hashes have been deprecated.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hashType} will
     * return {@link DocumentHashType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hashTypeString}.
     * </p>
     * 
     * @return Sha256 or Sha1.</p> <note>
     *         <p>
     *         Sha1 hashes have been deprecated.
     *         </p>
     * @see DocumentHashType
     */
    public String hashTypeString() {
        return hashType;
    }

    /**
     * <p>
     * The name of the SSM document.
     * </p>
     * 
     * @return The name of the SSM document.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The AWS user account of the person who created the document.
     * </p>
     * 
     * @return The AWS user account of the person who created the document.
     */
    public String owner() {
        return owner;
    }

    /**
     * <p>
     * The date when the document was created.
     * </p>
     * 
     * @return The date when the document was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The status of the SSM document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DocumentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The status of the SSM document.
     * @see DocumentStatus
     */
    public DocumentStatus status() {
        return DocumentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the SSM document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DocumentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The status of the SSM document.
     * @see DocumentStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * <p>
     * The document version.
     * </p>
     * 
     * @return The document version.
     */
    public String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * A description of the document.
     * </p>
     * 
     * @return A description of the document.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A description of the parameters for a document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A description of the parameters for a document.
     */
    public List<DocumentParameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The list of OS platforms compatible with this SSM document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of OS platforms compatible with this SSM document.
     */
    public List<PlatformType> platformTypes() {
        return TypeConverter.convert(platformTypes, PlatformType::fromValue);
    }

    /**
     * <p>
     * The list of OS platforms compatible with this SSM document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of OS platforms compatible with this SSM document.
     */
    public List<String> platformTypesStrings() {
        return platformTypes;
    }

    /**
     * <p>
     * The type of document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentType} will
     * return {@link DocumentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #documentTypeString}.
     * </p>
     * 
     * @return The type of document.
     * @see DocumentType
     */
    public DocumentType documentType() {
        return DocumentType.fromValue(documentType);
    }

    /**
     * <p>
     * The type of document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentType} will
     * return {@link DocumentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #documentTypeString}.
     * </p>
     * 
     * @return The type of document.
     * @see DocumentType
     */
    public String documentTypeString() {
        return documentType;
    }

    /**
     * <p>
     * The schema version.
     * </p>
     * 
     * @return The schema version.
     */
    public String schemaVersion() {
        return schemaVersion;
    }

    /**
     * <p>
     * The latest version of the document.
     * </p>
     * 
     * @return The latest version of the document.
     */
    public String latestVersion() {
        return latestVersion;
    }

    /**
     * <p>
     * The default version.
     * </p>
     * 
     * @return The default version.
     */
    public String defaultVersion() {
        return defaultVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((sha1() == null) ? 0 : sha1().hashCode());
        hashCode = 31 * hashCode + ((hash() == null) ? 0 : hash().hashCode());
        hashCode = 31 * hashCode + ((hashTypeString() == null) ? 0 : hashTypeString().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((owner() == null) ? 0 : owner().hashCode());
        hashCode = 31 * hashCode + ((createdDate() == null) ? 0 : createdDate().hashCode());
        hashCode = 31 * hashCode + ((statusString() == null) ? 0 : statusString().hashCode());
        hashCode = 31 * hashCode + ((documentVersion() == null) ? 0 : documentVersion().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((parameters() == null) ? 0 : parameters().hashCode());
        hashCode = 31 * hashCode + ((platformTypesStrings() == null) ? 0 : platformTypesStrings().hashCode());
        hashCode = 31 * hashCode + ((documentTypeString() == null) ? 0 : documentTypeString().hashCode());
        hashCode = 31 * hashCode + ((schemaVersion() == null) ? 0 : schemaVersion().hashCode());
        hashCode = 31 * hashCode + ((latestVersion() == null) ? 0 : latestVersion().hashCode());
        hashCode = 31 * hashCode + ((defaultVersion() == null) ? 0 : defaultVersion().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentDescription)) {
            return false;
        }
        DocumentDescription other = (DocumentDescription) obj;
        if (other.sha1() == null ^ this.sha1() == null) {
            return false;
        }
        if (other.sha1() != null && !other.sha1().equals(this.sha1())) {
            return false;
        }
        if (other.hash() == null ^ this.hash() == null) {
            return false;
        }
        if (other.hash() != null && !other.hash().equals(this.hash())) {
            return false;
        }
        if (other.hashTypeString() == null ^ this.hashTypeString() == null) {
            return false;
        }
        if (other.hashTypeString() != null && !other.hashTypeString().equals(this.hashTypeString())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        if (other.owner() != null && !other.owner().equals(this.owner())) {
            return false;
        }
        if (other.createdDate() == null ^ this.createdDate() == null) {
            return false;
        }
        if (other.createdDate() != null && !other.createdDate().equals(this.createdDate())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.documentVersion() == null ^ this.documentVersion() == null) {
            return false;
        }
        if (other.documentVersion() != null && !other.documentVersion().equals(this.documentVersion())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.platformTypesStrings() == null ^ this.platformTypesStrings() == null) {
            return false;
        }
        if (other.platformTypesStrings() != null && !other.platformTypesStrings().equals(this.platformTypesStrings())) {
            return false;
        }
        if (other.documentTypeString() == null ^ this.documentTypeString() == null) {
            return false;
        }
        if (other.documentTypeString() != null && !other.documentTypeString().equals(this.documentTypeString())) {
            return false;
        }
        if (other.schemaVersion() == null ^ this.schemaVersion() == null) {
            return false;
        }
        if (other.schemaVersion() != null && !other.schemaVersion().equals(this.schemaVersion())) {
            return false;
        }
        if (other.latestVersion() == null ^ this.latestVersion() == null) {
            return false;
        }
        if (other.latestVersion() != null && !other.latestVersion().equals(this.latestVersion())) {
            return false;
        }
        if (other.defaultVersion() == null ^ this.defaultVersion() == null) {
            return false;
        }
        if (other.defaultVersion() != null && !other.defaultVersion().equals(this.defaultVersion())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (sha1() != null) {
            sb.append("Sha1: ").append(sha1()).append(",");
        }
        if (hash() != null) {
            sb.append("Hash: ").append(hash()).append(",");
        }
        if (hashTypeString() != null) {
            sb.append("HashType: ").append(hashTypeString()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (owner() != null) {
            sb.append("Owner: ").append(owner()).append(",");
        }
        if (createdDate() != null) {
            sb.append("CreatedDate: ").append(createdDate()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (documentVersion() != null) {
            sb.append("DocumentVersion: ").append(documentVersion()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (platformTypesStrings() != null) {
            sb.append("PlatformTypes: ").append(platformTypesStrings()).append(",");
        }
        if (documentTypeString() != null) {
            sb.append("DocumentType: ").append(documentTypeString()).append(",");
        }
        if (schemaVersion() != null) {
            sb.append("SchemaVersion: ").append(schemaVersion()).append(",");
        }
        if (latestVersion() != null) {
            sb.append("LatestVersion: ").append(latestVersion()).append(",");
        }
        if (defaultVersion() != null) {
            sb.append("DefaultVersion: ").append(defaultVersion()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Sha1":
            return Optional.of(clazz.cast(sha1()));
        case "Hash":
            return Optional.of(clazz.cast(hash()));
        case "HashType":
            return Optional.of(clazz.cast(hashTypeString()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Owner":
            return Optional.of(clazz.cast(owner()));
        case "CreatedDate":
            return Optional.of(clazz.cast(createdDate()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        case "DocumentVersion":
            return Optional.of(clazz.cast(documentVersion()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Parameters":
            return Optional.of(clazz.cast(parameters()));
        case "PlatformTypes":
            return Optional.of(clazz.cast(platformTypesStrings()));
        case "DocumentType":
            return Optional.of(clazz.cast(documentTypeString()));
        case "SchemaVersion":
            return Optional.of(clazz.cast(schemaVersion()));
        case "LatestVersion":
            return Optional.of(clazz.cast(latestVersion()));
        case "DefaultVersion":
            return Optional.of(clazz.cast(defaultVersion()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DocumentDescription> {
        /**
         * <p>
         * The SHA1 hash of the document, which you can use for verification purposes.
         * </p>
         * 
         * @param sha1
         *        The SHA1 hash of the document, which you can use for verification purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sha1(String sha1);

        /**
         * <p>
         * The Sha256 or Sha1 hash created by the system when the document was created.
         * </p>
         * <note>
         * <p>
         * Sha1 hashes have been deprecated.
         * </p>
         * </note>
         * 
         * @param hash
         *        The Sha256 or Sha1 hash created by the system when the document was created. </p> <note>
         *        <p>
         *        Sha1 hashes have been deprecated.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hash(String hash);

        /**
         * <p>
         * Sha256 or Sha1.
         * </p>
         * <note>
         * <p>
         * Sha1 hashes have been deprecated.
         * </p>
         * </note>
         * 
         * @param hashType
         *        Sha256 or Sha1.</p> <note>
         *        <p>
         *        Sha1 hashes have been deprecated.
         *        </p>
         * @see DocumentHashType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentHashType
         */
        Builder hashType(String hashType);

        /**
         * <p>
         * Sha256 or Sha1.
         * </p>
         * <note>
         * <p>
         * Sha1 hashes have been deprecated.
         * </p>
         * </note>
         * 
         * @param hashType
         *        Sha256 or Sha1.</p> <note>
         *        <p>
         *        Sha1 hashes have been deprecated.
         *        </p>
         * @see DocumentHashType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentHashType
         */
        Builder hashType(DocumentHashType hashType);

        /**
         * <p>
         * The name of the SSM document.
         * </p>
         * 
         * @param name
         *        The name of the SSM document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The AWS user account of the person who created the document.
         * </p>
         * 
         * @param owner
         *        The AWS user account of the person who created the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The date when the document was created.
         * </p>
         * 
         * @param createdDate
         *        The date when the document was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The status of the SSM document.
         * </p>
         * 
         * @param status
         *        The status of the SSM document.
         * @see DocumentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the SSM document.
         * </p>
         * 
         * @param status
         *        The status of the SSM document.
         * @see DocumentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentStatus
         */
        Builder status(DocumentStatus status);

        /**
         * <p>
         * The document version.
         * </p>
         * 
         * @param documentVersion
         *        The document version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * A description of the document.
         * </p>
         * 
         * @param description
         *        A description of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A description of the parameters for a document.
         * </p>
         * 
         * @param parameters
         *        A description of the parameters for a document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<DocumentParameter> parameters);

        /**
         * <p>
         * A description of the parameters for a document.
         * </p>
         * 
         * @param parameters
         *        A description of the parameters for a document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(DocumentParameter... parameters);

        /**
         * <p>
         * The list of OS platforms compatible with this SSM document.
         * </p>
         * 
         * @param platformTypes
         *        The list of OS platforms compatible with this SSM document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformTypes(Collection<String> platformTypes);

        /**
         * <p>
         * The list of OS platforms compatible with this SSM document.
         * </p>
         * 
         * @param platformTypes
         *        The list of OS platforms compatible with this SSM document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformTypes(String... platformTypes);

        /**
         * <p>
         * The type of document.
         * </p>
         * 
         * @param documentType
         *        The type of document.
         * @see DocumentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentType
         */
        Builder documentType(String documentType);

        /**
         * <p>
         * The type of document.
         * </p>
         * 
         * @param documentType
         *        The type of document.
         * @see DocumentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentType
         */
        Builder documentType(DocumentType documentType);

        /**
         * <p>
         * The schema version.
         * </p>
         * 
         * @param schemaVersion
         *        The schema version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersion(String schemaVersion);

        /**
         * <p>
         * The latest version of the document.
         * </p>
         * 
         * @param latestVersion
         *        The latest version of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersion(String latestVersion);

        /**
         * <p>
         * The default version.
         * </p>
         * 
         * @param defaultVersion
         *        The default version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersion(String defaultVersion);
    }

    static final class BuilderImpl implements Builder {
        private String sha1;

        private String hash;

        private String hashType;

        private String name;

        private String owner;

        private Instant createdDate;

        private String status;

        private String documentVersion;

        private String description;

        private List<DocumentParameter> parameters;

        private List<String> platformTypes;

        private String documentType;

        private String schemaVersion;

        private String latestVersion;

        private String defaultVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentDescription model) {
            sha1(model.sha1);
            hash(model.hash);
            hashType(model.hashType);
            name(model.name);
            owner(model.owner);
            createdDate(model.createdDate);
            status(model.status);
            documentVersion(model.documentVersion);
            description(model.description);
            parameters(model.parameters);
            platformTypes(model.platformTypes);
            documentType(model.documentType);
            schemaVersion(model.schemaVersion);
            latestVersion(model.latestVersion);
            defaultVersion(model.defaultVersion);
        }

        public final String getSha1() {
            return sha1;
        }

        @Override
        public final Builder sha1(String sha1) {
            this.sha1 = sha1;
            return this;
        }

        public final void setSha1(String sha1) {
            this.sha1 = sha1;
        }

        public final String getHash() {
            return hash;
        }

        @Override
        public final Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public final void setHash(String hash) {
            this.hash = hash;
        }

        public final String getHashType() {
            return hashType;
        }

        @Override
        public final Builder hashType(String hashType) {
            this.hashType = hashType;
            return this;
        }

        @Override
        public final Builder hashType(DocumentHashType hashType) {
            this.hashType(hashType.toString());
            return this;
        }

        public final void setHashType(String hashType) {
            this.hashType = hashType;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DocumentStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<DocumentParameter.Builder> getParameters() {
            return parameters != null ? parameters.stream().map(DocumentParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<DocumentParameter> parameters) {
            this.parameters = DocumentParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(DocumentParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<DocumentParameter.BuilderImpl> parameters) {
            this.parameters = DocumentParameterListCopier.copyFromBuilder(parameters);
        }

        public final Collection<String> getPlatformTypes() {
            return platformTypes;
        }

        @Override
        public final Builder platformTypes(Collection<String> platformTypes) {
            this.platformTypes = PlatformTypeListCopier.copy(platformTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformTypes(String... platformTypes) {
            platformTypes(Arrays.asList(platformTypes));
            return this;
        }

        public final void setPlatformTypes(Collection<String> platformTypes) {
            this.platformTypes = PlatformTypeListCopier.copy(platformTypes);
        }

        public final String getDocumentType() {
            return documentType;
        }

        @Override
        public final Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        @Override
        public final Builder documentType(DocumentType documentType) {
            this.documentType(documentType.toString());
            return this;
        }

        public final void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        public final String getSchemaVersion() {
            return schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final String getLatestVersion() {
            return latestVersion;
        }

        @Override
        public final Builder latestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final void setLatestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
        }

        public final String getDefaultVersion() {
            return defaultVersion;
        }

        @Override
        public final Builder defaultVersion(String defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this;
        }

        public final void setDefaultVersion(String defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        @Override
        public DocumentDescription build() {
            return new DocumentDescription(this);
        }
    }
}
