/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetParameterResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetParameterResponse.Builder, GetParameterResponse> {
    private final Parameter parameter;

    private GetParameterResponse(BuilderImpl builder) {
        this.parameter = builder.parameter;
    }

    /**
     * <p>
     * Information about a parameter.
     * </p>
     * 
     * @return Information about a parameter.
     */
    public Parameter parameter() {
        return parameter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((parameter() == null) ? 0 : parameter().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParameterResponse)) {
            return false;
        }
        GetParameterResponse other = (GetParameterResponse) obj;
        if (other.parameter() == null ^ this.parameter() == null) {
            return false;
        }
        if (other.parameter() != null && !other.parameter().equals(this.parameter())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (parameter() != null) {
            sb.append("Parameter: ").append(parameter()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Parameter":
            return Optional.of(clazz.cast(parameter()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetParameterResponse> {
        /**
         * <p>
         * Information about a parameter.
         * </p>
         * 
         * @param parameter
         *        Information about a parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameter(Parameter parameter);
    }

    static final class BuilderImpl implements Builder {
        private Parameter parameter;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParameterResponse model) {
            parameter(model.parameter);
        }

        public final Parameter.Builder getParameter() {
            return parameter != null ? parameter.toBuilder() : null;
        }

        @Override
        public final Builder parameter(Parameter parameter) {
            this.parameter = parameter;
            return this;
        }

        public final void setParameter(Parameter.BuilderImpl parameter) {
            this.parameter = parameter != null ? parameter.build() : null;
        }

        @Override
        public GetParameterResponse build() {
            return new GetParameterResponse(this);
        }
    }
}
