/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetPatchBaselineRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetPatchBaselineRequest.Builder, GetPatchBaselineRequest> {
    private final String baselineId;

    private GetPatchBaselineRequest(BuilderImpl builder) {
        this.baselineId = builder.baselineId;
    }

    /**
     * <p>
     * The ID of the patch baseline to retrieve.
     * </p>
     * 
     * @return The ID of the patch baseline to retrieve.
     */
    public String baselineId() {
        return baselineId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((baselineId() == null) ? 0 : baselineId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPatchBaselineRequest)) {
            return false;
        }
        GetPatchBaselineRequest other = (GetPatchBaselineRequest) obj;
        if (other.baselineId() == null ^ this.baselineId() == null) {
            return false;
        }
        if (other.baselineId() != null && !other.baselineId().equals(this.baselineId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (baselineId() != null) {
            sb.append("BaselineId: ").append(baselineId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaselineId":
            return Optional.of(clazz.cast(baselineId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetPatchBaselineRequest> {
        /**
         * <p>
         * The ID of the patch baseline to retrieve.
         * </p>
         * 
         * @param baselineId
         *        The ID of the patch baseline to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineId(String baselineId);
    }

    static final class BuilderImpl implements Builder {
        private String baselineId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPatchBaselineRequest model) {
            baselineId(model.baselineId);
        }

        public final String getBaselineId() {
            return baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        @Override
        public GetPatchBaselineRequest build() {
            return new GetPatchBaselineRequest(this);
        }
    }
}
