/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.InstanceAssociationOutputLocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon S3 bucket where you want to store the results of this request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceAssociationOutputLocation implements StructuredPojo,
        ToCopyableBuilder<InstanceAssociationOutputLocation.Builder, InstanceAssociationOutputLocation> {
    private final S3OutputLocation s3Location;

    private InstanceAssociationOutputLocation(BuilderImpl builder) {
        this.s3Location = builder.s3Location;
    }

    /**
     * <p>
     * An Amazon S3 bucket where you want to store the results of this request.
     * </p>
     * 
     * @return An Amazon S3 bucket where you want to store the results of this request.
     */
    public S3OutputLocation s3Location() {
        return s3Location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((s3Location() == null) ? 0 : s3Location().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAssociationOutputLocation)) {
            return false;
        }
        InstanceAssociationOutputLocation other = (InstanceAssociationOutputLocation) obj;
        if (other.s3Location() == null ^ this.s3Location() == null) {
            return false;
        }
        if (other.s3Location() != null && !other.s3Location().equals(this.s3Location())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (s3Location() != null) {
            sb.append("S3Location: ").append(s3Location()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Location":
            return Optional.of(clazz.cast(s3Location()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceAssociationOutputLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceAssociationOutputLocation> {
        /**
         * <p>
         * An Amazon S3 bucket where you want to store the results of this request.
         * </p>
         * 
         * @param s3Location
         *        An Amazon S3 bucket where you want to store the results of this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Location(S3OutputLocation s3Location);
    }

    static final class BuilderImpl implements Builder {
        private S3OutputLocation s3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAssociationOutputLocation model) {
            s3Location(model.s3Location);
        }

        public final S3OutputLocation.Builder getS3Location() {
            return s3Location != null ? s3Location.toBuilder() : null;
        }

        @Override
        public final Builder s3Location(S3OutputLocation s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final void setS3Location(S3OutputLocation.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        @Override
        public InstanceAssociationOutputLocation build() {
            return new InstanceAssociationOutputLocation(this);
        }
    }
}
