/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.InstanceAssociationStatusInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Status information about the instance association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceAssociationStatusInfo implements StructuredPojo,
        ToCopyableBuilder<InstanceAssociationStatusInfo.Builder, InstanceAssociationStatusInfo> {
    private final String associationId;

    private final String name;

    private final String documentVersion;

    private final String instanceId;

    private final Instant executionDate;

    private final String status;

    private final String detailedStatus;

    private final String executionSummary;

    private final String errorCode;

    private final InstanceAssociationOutputUrl outputUrl;

    private InstanceAssociationStatusInfo(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.name = builder.name;
        this.documentVersion = builder.documentVersion;
        this.instanceId = builder.instanceId;
        this.executionDate = builder.executionDate;
        this.status = builder.status;
        this.detailedStatus = builder.detailedStatus;
        this.executionSummary = builder.executionSummary;
        this.errorCode = builder.errorCode;
        this.outputUrl = builder.outputUrl;
    }

    /**
     * <p>
     * The association ID.
     * </p>
     * 
     * @return The association ID.
     */
    public String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The name of the association.
     * </p>
     * 
     * @return The name of the association.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The association document verions.
     * </p>
     * 
     * @return The association document verions.
     */
    public String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * The instance ID where the association was created.
     * </p>
     * 
     * @return The instance ID where the association was created.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The date the instance association executed.
     * </p>
     * 
     * @return The date the instance association executed.
     */
    public Instant executionDate() {
        return executionDate;
    }

    /**
     * <p>
     * Status information about the instance association.
     * </p>
     * 
     * @return Status information about the instance association.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * Detailed status information about the instance association.
     * </p>
     * 
     * @return Detailed status information about the instance association.
     */
    public String detailedStatus() {
        return detailedStatus;
    }

    /**
     * <p>
     * Summary information about association execution.
     * </p>
     * 
     * @return Summary information about association execution.
     */
    public String executionSummary() {
        return executionSummary;
    }

    /**
     * <p>
     * An error code returned by the request to create the association.
     * </p>
     * 
     * @return An error code returned by the request to create the association.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * A URL for an Amazon S3 bucket where you want to store the results of this request.
     * </p>
     * 
     * @return A URL for an Amazon S3 bucket where you want to store the results of this request.
     */
    public InstanceAssociationOutputUrl outputUrl() {
        return outputUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((associationId() == null) ? 0 : associationId().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((documentVersion() == null) ? 0 : documentVersion().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((executionDate() == null) ? 0 : executionDate().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((detailedStatus() == null) ? 0 : detailedStatus().hashCode());
        hashCode = 31 * hashCode + ((executionSummary() == null) ? 0 : executionSummary().hashCode());
        hashCode = 31 * hashCode + ((errorCode() == null) ? 0 : errorCode().hashCode());
        hashCode = 31 * hashCode + ((outputUrl() == null) ? 0 : outputUrl().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAssociationStatusInfo)) {
            return false;
        }
        InstanceAssociationStatusInfo other = (InstanceAssociationStatusInfo) obj;
        if (other.associationId() == null ^ this.associationId() == null) {
            return false;
        }
        if (other.associationId() != null && !other.associationId().equals(this.associationId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.documentVersion() == null ^ this.documentVersion() == null) {
            return false;
        }
        if (other.documentVersion() != null && !other.documentVersion().equals(this.documentVersion())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.executionDate() == null ^ this.executionDate() == null) {
            return false;
        }
        if (other.executionDate() != null && !other.executionDate().equals(this.executionDate())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.detailedStatus() == null ^ this.detailedStatus() == null) {
            return false;
        }
        if (other.detailedStatus() != null && !other.detailedStatus().equals(this.detailedStatus())) {
            return false;
        }
        if (other.executionSummary() == null ^ this.executionSummary() == null) {
            return false;
        }
        if (other.executionSummary() != null && !other.executionSummary().equals(this.executionSummary())) {
            return false;
        }
        if (other.errorCode() == null ^ this.errorCode() == null) {
            return false;
        }
        if (other.errorCode() != null && !other.errorCode().equals(this.errorCode())) {
            return false;
        }
        if (other.outputUrl() == null ^ this.outputUrl() == null) {
            return false;
        }
        if (other.outputUrl() != null && !other.outputUrl().equals(this.outputUrl())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (associationId() != null) {
            sb.append("AssociationId: ").append(associationId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (documentVersion() != null) {
            sb.append("DocumentVersion: ").append(documentVersion()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (executionDate() != null) {
            sb.append("ExecutionDate: ").append(executionDate()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (detailedStatus() != null) {
            sb.append("DetailedStatus: ").append(detailedStatus()).append(",");
        }
        if (executionSummary() != null) {
            sb.append("ExecutionSummary: ").append(executionSummary()).append(",");
        }
        if (errorCode() != null) {
            sb.append("ErrorCode: ").append(errorCode()).append(",");
        }
        if (outputUrl() != null) {
            sb.append("OutputUrl: ").append(outputUrl()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationId":
            return Optional.of(clazz.cast(associationId()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "DocumentVersion":
            return Optional.of(clazz.cast(documentVersion()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "ExecutionDate":
            return Optional.of(clazz.cast(executionDate()));
        case "Status":
            return Optional.of(clazz.cast(status()));
        case "DetailedStatus":
            return Optional.of(clazz.cast(detailedStatus()));
        case "ExecutionSummary":
            return Optional.of(clazz.cast(executionSummary()));
        case "ErrorCode":
            return Optional.of(clazz.cast(errorCode()));
        case "OutputUrl":
            return Optional.of(clazz.cast(outputUrl()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceAssociationStatusInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceAssociationStatusInfo> {
        /**
         * <p>
         * The association ID.
         * </p>
         * 
         * @param associationId
         *        The association ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The name of the association.
         * </p>
         * 
         * @param name
         *        The name of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The association document verions.
         * </p>
         * 
         * @param documentVersion
         *        The association document verions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * The instance ID where the association was created.
         * </p>
         * 
         * @param instanceId
         *        The instance ID where the association was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The date the instance association executed.
         * </p>
         * 
         * @param executionDate
         *        The date the instance association executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionDate(Instant executionDate);

        /**
         * <p>
         * Status information about the instance association.
         * </p>
         * 
         * @param status
         *        Status information about the instance association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Detailed status information about the instance association.
         * </p>
         * 
         * @param detailedStatus
         *        Detailed status information about the instance association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailedStatus(String detailedStatus);

        /**
         * <p>
         * Summary information about association execution.
         * </p>
         * 
         * @param executionSummary
         *        Summary information about association execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionSummary(String executionSummary);

        /**
         * <p>
         * An error code returned by the request to create the association.
         * </p>
         * 
         * @param errorCode
         *        An error code returned by the request to create the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * A URL for an Amazon S3 bucket where you want to store the results of this request.
         * </p>
         * 
         * @param outputUrl
         *        A URL for an Amazon S3 bucket where you want to store the results of this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputUrl(InstanceAssociationOutputUrl outputUrl);
    }

    static final class BuilderImpl implements Builder {
        private String associationId;

        private String name;

        private String documentVersion;

        private String instanceId;

        private Instant executionDate;

        private String status;

        private String detailedStatus;

        private String executionSummary;

        private String errorCode;

        private InstanceAssociationOutputUrl outputUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAssociationStatusInfo model) {
            associationId(model.associationId);
            name(model.name);
            documentVersion(model.documentVersion);
            instanceId(model.instanceId);
            executionDate(model.executionDate);
            status(model.status);
            detailedStatus(model.detailedStatus);
            executionSummary(model.executionSummary);
            errorCode(model.errorCode);
            outputUrl(model.outputUrl);
        }

        public final String getAssociationId() {
            return associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Instant getExecutionDate() {
            return executionDate;
        }

        @Override
        public final Builder executionDate(Instant executionDate) {
            this.executionDate = executionDate;
            return this;
        }

        public final void setExecutionDate(Instant executionDate) {
            this.executionDate = executionDate;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDetailedStatus() {
            return detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        public final String getExecutionSummary() {
            return executionSummary;
        }

        @Override
        public final Builder executionSummary(String executionSummary) {
            this.executionSummary = executionSummary;
            return this;
        }

        public final void setExecutionSummary(String executionSummary) {
            this.executionSummary = executionSummary;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final InstanceAssociationOutputUrl.Builder getOutputUrl() {
            return outputUrl != null ? outputUrl.toBuilder() : null;
        }

        @Override
        public final Builder outputUrl(InstanceAssociationOutputUrl outputUrl) {
            this.outputUrl = outputUrl;
            return this;
        }

        public final void setOutputUrl(InstanceAssociationOutputUrl.BuilderImpl outputUrl) {
            this.outputUrl = outputUrl != null ? outputUrl.build() : null;
        }

        @Override
        public InstanceAssociationStatusInfo build() {
            return new InstanceAssociationStatusInfo(this);
        }
    }
}
