/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.InstanceInformationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a filter for a specific list of instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceInformation implements StructuredPojo, ToCopyableBuilder<InstanceInformation.Builder, InstanceInformation> {
    private final String instanceId;

    private final String pingStatus;

    private final Instant lastPingDateTime;

    private final String agentVersion;

    private final Boolean isLatestVersion;

    private final String platformType;

    private final String platformName;

    private final String platformVersion;

    private final String activationId;

    private final String iamRole;

    private final Instant registrationDate;

    private final String resourceType;

    private final String name;

    private final String ipAddress;

    private final String computerName;

    private final String associationStatus;

    private final Instant lastAssociationExecutionDate;

    private final Instant lastSuccessfulAssociationExecutionDate;

    private final InstanceAggregatedAssociationOverview associationOverview;

    private InstanceInformation(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.pingStatus = builder.pingStatus;
        this.lastPingDateTime = builder.lastPingDateTime;
        this.agentVersion = builder.agentVersion;
        this.isLatestVersion = builder.isLatestVersion;
        this.platformType = builder.platformType;
        this.platformName = builder.platformName;
        this.platformVersion = builder.platformVersion;
        this.activationId = builder.activationId;
        this.iamRole = builder.iamRole;
        this.registrationDate = builder.registrationDate;
        this.resourceType = builder.resourceType;
        this.name = builder.name;
        this.ipAddress = builder.ipAddress;
        this.computerName = builder.computerName;
        this.associationStatus = builder.associationStatus;
        this.lastAssociationExecutionDate = builder.lastAssociationExecutionDate;
        this.lastSuccessfulAssociationExecutionDate = builder.lastSuccessfulAssociationExecutionDate;
        this.associationOverview = builder.associationOverview;
    }

    /**
     * <p>
     * The instance ID.
     * </p>
     * 
     * @return The instance ID.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Connection status of the SSM Agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pingStatus} will
     * return {@link PingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pingStatusString}.
     * </p>
     * 
     * @return Connection status of the SSM Agent.
     * @see PingStatus
     */
    public PingStatus pingStatus() {
        return PingStatus.fromValue(pingStatus);
    }

    /**
     * <p>
     * Connection status of the SSM Agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pingStatus} will
     * return {@link PingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pingStatusString}.
     * </p>
     * 
     * @return Connection status of the SSM Agent.
     * @see PingStatus
     */
    public String pingStatusString() {
        return pingStatus;
    }

    /**
     * <p>
     * The date and time when agent last pinged Systems Manager service.
     * </p>
     * 
     * @return The date and time when agent last pinged Systems Manager service.
     */
    public Instant lastPingDateTime() {
        return lastPingDateTime;
    }

    /**
     * <p>
     * The version of the SSM Agent running on your Linux instance.
     * </p>
     * 
     * @return The version of the SSM Agent running on your Linux instance.
     */
    public String agentVersion() {
        return agentVersion;
    }

    /**
     * <p>
     * Indicates whether latest version of the SSM Agent is running on your instance.
     * </p>
     * 
     * @return Indicates whether latest version of the SSM Agent is running on your instance.
     */
    public Boolean isLatestVersion() {
        return isLatestVersion;
    }

    /**
     * <p>
     * The operating system platform type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platformType} will
     * return {@link PlatformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformTypeString}.
     * </p>
     * 
     * @return The operating system platform type.
     * @see PlatformType
     */
    public PlatformType platformType() {
        return PlatformType.fromValue(platformType);
    }

    /**
     * <p>
     * The operating system platform type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platformType} will
     * return {@link PlatformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformTypeString}.
     * </p>
     * 
     * @return The operating system platform type.
     * @see PlatformType
     */
    public String platformTypeString() {
        return platformType;
    }

    /**
     * <p>
     * The name of the operating system platform running on your instance.
     * </p>
     * 
     * @return The name of the operating system platform running on your instance.
     */
    public String platformName() {
        return platformName;
    }

    /**
     * <p>
     * The version of the OS platform running on your instance.
     * </p>
     * 
     * @return The version of the OS platform running on your instance.
     */
    public String platformVersion() {
        return platformVersion;
    }

    /**
     * <p>
     * The activation ID created by Systems Manager when the server or VM was registered.
     * </p>
     * 
     * @return The activation ID created by Systems Manager when the server or VM was registered.
     */
    public String activationId() {
        return activationId;
    }

    /**
     * <p>
     * The Amazon Identity and Access Management (IAM) role assigned to EC2 instances or managed instances.
     * </p>
     * 
     * @return The Amazon Identity and Access Management (IAM) role assigned to EC2 instances or managed instances.
     */
    public String iamRole() {
        return iamRole;
    }

    /**
     * <p>
     * The date the server or VM was registered with AWS as a managed instance.
     * </p>
     * 
     * @return The date the server or VM was registered with AWS as a managed instance.
     */
    public Instant registrationDate() {
        return registrationDate;
    }

    /**
     * <p>
     * The type of instance. Instances are either EC2 instances or managed instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of instance. Instances are either EC2 instances or managed instances.
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of instance. Instances are either EC2 instances or managed instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of instance. Instances are either EC2 instances or managed instances.
     * @see ResourceType
     */
    public String resourceTypeString() {
        return resourceType;
    }

    /**
     * <p>
     * The name of the managed instance.
     * </p>
     * 
     * @return The name of the managed instance.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The IP address of the managed instance.
     * </p>
     * 
     * @return The IP address of the managed instance.
     */
    public String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The fully qualified host name of the managed instance.
     * </p>
     * 
     * @return The fully qualified host name of the managed instance.
     */
    public String computerName() {
        return computerName;
    }

    /**
     * <p>
     * The status of the association.
     * </p>
     * 
     * @return The status of the association.
     */
    public String associationStatus() {
        return associationStatus;
    }

    /**
     * <p>
     * The date the association was last executed.
     * </p>
     * 
     * @return The date the association was last executed.
     */
    public Instant lastAssociationExecutionDate() {
        return lastAssociationExecutionDate;
    }

    /**
     * <p>
     * The last date the association was successfully run.
     * </p>
     * 
     * @return The last date the association was successfully run.
     */
    public Instant lastSuccessfulAssociationExecutionDate() {
        return lastSuccessfulAssociationExecutionDate;
    }

    /**
     * <p>
     * Information about the association.
     * </p>
     * 
     * @return Information about the association.
     */
    public InstanceAggregatedAssociationOverview associationOverview() {
        return associationOverview;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((pingStatusString() == null) ? 0 : pingStatusString().hashCode());
        hashCode = 31 * hashCode + ((lastPingDateTime() == null) ? 0 : lastPingDateTime().hashCode());
        hashCode = 31 * hashCode + ((agentVersion() == null) ? 0 : agentVersion().hashCode());
        hashCode = 31 * hashCode + ((isLatestVersion() == null) ? 0 : isLatestVersion().hashCode());
        hashCode = 31 * hashCode + ((platformTypeString() == null) ? 0 : platformTypeString().hashCode());
        hashCode = 31 * hashCode + ((platformName() == null) ? 0 : platformName().hashCode());
        hashCode = 31 * hashCode + ((platformVersion() == null) ? 0 : platformVersion().hashCode());
        hashCode = 31 * hashCode + ((activationId() == null) ? 0 : activationId().hashCode());
        hashCode = 31 * hashCode + ((iamRole() == null) ? 0 : iamRole().hashCode());
        hashCode = 31 * hashCode + ((registrationDate() == null) ? 0 : registrationDate().hashCode());
        hashCode = 31 * hashCode + ((resourceTypeString() == null) ? 0 : resourceTypeString().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((ipAddress() == null) ? 0 : ipAddress().hashCode());
        hashCode = 31 * hashCode + ((computerName() == null) ? 0 : computerName().hashCode());
        hashCode = 31 * hashCode + ((associationStatus() == null) ? 0 : associationStatus().hashCode());
        hashCode = 31 * hashCode + ((lastAssociationExecutionDate() == null) ? 0 : lastAssociationExecutionDate().hashCode());
        hashCode = 31 * hashCode
                + ((lastSuccessfulAssociationExecutionDate() == null) ? 0 : lastSuccessfulAssociationExecutionDate().hashCode());
        hashCode = 31 * hashCode + ((associationOverview() == null) ? 0 : associationOverview().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceInformation)) {
            return false;
        }
        InstanceInformation other = (InstanceInformation) obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.pingStatusString() == null ^ this.pingStatusString() == null) {
            return false;
        }
        if (other.pingStatusString() != null && !other.pingStatusString().equals(this.pingStatusString())) {
            return false;
        }
        if (other.lastPingDateTime() == null ^ this.lastPingDateTime() == null) {
            return false;
        }
        if (other.lastPingDateTime() != null && !other.lastPingDateTime().equals(this.lastPingDateTime())) {
            return false;
        }
        if (other.agentVersion() == null ^ this.agentVersion() == null) {
            return false;
        }
        if (other.agentVersion() != null && !other.agentVersion().equals(this.agentVersion())) {
            return false;
        }
        if (other.isLatestVersion() == null ^ this.isLatestVersion() == null) {
            return false;
        }
        if (other.isLatestVersion() != null && !other.isLatestVersion().equals(this.isLatestVersion())) {
            return false;
        }
        if (other.platformTypeString() == null ^ this.platformTypeString() == null) {
            return false;
        }
        if (other.platformTypeString() != null && !other.platformTypeString().equals(this.platformTypeString())) {
            return false;
        }
        if (other.platformName() == null ^ this.platformName() == null) {
            return false;
        }
        if (other.platformName() != null && !other.platformName().equals(this.platformName())) {
            return false;
        }
        if (other.platformVersion() == null ^ this.platformVersion() == null) {
            return false;
        }
        if (other.platformVersion() != null && !other.platformVersion().equals(this.platformVersion())) {
            return false;
        }
        if (other.activationId() == null ^ this.activationId() == null) {
            return false;
        }
        if (other.activationId() != null && !other.activationId().equals(this.activationId())) {
            return false;
        }
        if (other.iamRole() == null ^ this.iamRole() == null) {
            return false;
        }
        if (other.iamRole() != null && !other.iamRole().equals(this.iamRole())) {
            return false;
        }
        if (other.registrationDate() == null ^ this.registrationDate() == null) {
            return false;
        }
        if (other.registrationDate() != null && !other.registrationDate().equals(this.registrationDate())) {
            return false;
        }
        if (other.resourceTypeString() == null ^ this.resourceTypeString() == null) {
            return false;
        }
        if (other.resourceTypeString() != null && !other.resourceTypeString().equals(this.resourceTypeString())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.ipAddress() == null ^ this.ipAddress() == null) {
            return false;
        }
        if (other.ipAddress() != null && !other.ipAddress().equals(this.ipAddress())) {
            return false;
        }
        if (other.computerName() == null ^ this.computerName() == null) {
            return false;
        }
        if (other.computerName() != null && !other.computerName().equals(this.computerName())) {
            return false;
        }
        if (other.associationStatus() == null ^ this.associationStatus() == null) {
            return false;
        }
        if (other.associationStatus() != null && !other.associationStatus().equals(this.associationStatus())) {
            return false;
        }
        if (other.lastAssociationExecutionDate() == null ^ this.lastAssociationExecutionDate() == null) {
            return false;
        }
        if (other.lastAssociationExecutionDate() != null
                && !other.lastAssociationExecutionDate().equals(this.lastAssociationExecutionDate())) {
            return false;
        }
        if (other.lastSuccessfulAssociationExecutionDate() == null ^ this.lastSuccessfulAssociationExecutionDate() == null) {
            return false;
        }
        if (other.lastSuccessfulAssociationExecutionDate() != null
                && !other.lastSuccessfulAssociationExecutionDate().equals(this.lastSuccessfulAssociationExecutionDate())) {
            return false;
        }
        if (other.associationOverview() == null ^ this.associationOverview() == null) {
            return false;
        }
        if (other.associationOverview() != null && !other.associationOverview().equals(this.associationOverview())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (pingStatusString() != null) {
            sb.append("PingStatus: ").append(pingStatusString()).append(",");
        }
        if (lastPingDateTime() != null) {
            sb.append("LastPingDateTime: ").append(lastPingDateTime()).append(",");
        }
        if (agentVersion() != null) {
            sb.append("AgentVersion: ").append(agentVersion()).append(",");
        }
        if (isLatestVersion() != null) {
            sb.append("IsLatestVersion: ").append(isLatestVersion()).append(",");
        }
        if (platformTypeString() != null) {
            sb.append("PlatformType: ").append(platformTypeString()).append(",");
        }
        if (platformName() != null) {
            sb.append("PlatformName: ").append(platformName()).append(",");
        }
        if (platformVersion() != null) {
            sb.append("PlatformVersion: ").append(platformVersion()).append(",");
        }
        if (activationId() != null) {
            sb.append("ActivationId: ").append(activationId()).append(",");
        }
        if (iamRole() != null) {
            sb.append("IamRole: ").append(iamRole()).append(",");
        }
        if (registrationDate() != null) {
            sb.append("RegistrationDate: ").append(registrationDate()).append(",");
        }
        if (resourceTypeString() != null) {
            sb.append("ResourceType: ").append(resourceTypeString()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (ipAddress() != null) {
            sb.append("IPAddress: ").append(ipAddress()).append(",");
        }
        if (computerName() != null) {
            sb.append("ComputerName: ").append(computerName()).append(",");
        }
        if (associationStatus() != null) {
            sb.append("AssociationStatus: ").append(associationStatus()).append(",");
        }
        if (lastAssociationExecutionDate() != null) {
            sb.append("LastAssociationExecutionDate: ").append(lastAssociationExecutionDate()).append(",");
        }
        if (lastSuccessfulAssociationExecutionDate() != null) {
            sb.append("LastSuccessfulAssociationExecutionDate: ").append(lastSuccessfulAssociationExecutionDate()).append(",");
        }
        if (associationOverview() != null) {
            sb.append("AssociationOverview: ").append(associationOverview()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "PingStatus":
            return Optional.of(clazz.cast(pingStatusString()));
        case "LastPingDateTime":
            return Optional.of(clazz.cast(lastPingDateTime()));
        case "AgentVersion":
            return Optional.of(clazz.cast(agentVersion()));
        case "IsLatestVersion":
            return Optional.of(clazz.cast(isLatestVersion()));
        case "PlatformType":
            return Optional.of(clazz.cast(platformTypeString()));
        case "PlatformName":
            return Optional.of(clazz.cast(platformName()));
        case "PlatformVersion":
            return Optional.of(clazz.cast(platformVersion()));
        case "ActivationId":
            return Optional.of(clazz.cast(activationId()));
        case "IamRole":
            return Optional.of(clazz.cast(iamRole()));
        case "RegistrationDate":
            return Optional.of(clazz.cast(registrationDate()));
        case "ResourceType":
            return Optional.of(clazz.cast(resourceTypeString()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "IPAddress":
            return Optional.of(clazz.cast(ipAddress()));
        case "ComputerName":
            return Optional.of(clazz.cast(computerName()));
        case "AssociationStatus":
            return Optional.of(clazz.cast(associationStatus()));
        case "LastAssociationExecutionDate":
            return Optional.of(clazz.cast(lastAssociationExecutionDate()));
        case "LastSuccessfulAssociationExecutionDate":
            return Optional.of(clazz.cast(lastSuccessfulAssociationExecutionDate()));
        case "AssociationOverview":
            return Optional.of(clazz.cast(associationOverview()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceInformationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceInformation> {
        /**
         * <p>
         * The instance ID.
         * </p>
         * 
         * @param instanceId
         *        The instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Connection status of the SSM Agent.
         * </p>
         * 
         * @param pingStatus
         *        Connection status of the SSM Agent.
         * @see PingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PingStatus
         */
        Builder pingStatus(String pingStatus);

        /**
         * <p>
         * Connection status of the SSM Agent.
         * </p>
         * 
         * @param pingStatus
         *        Connection status of the SSM Agent.
         * @see PingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PingStatus
         */
        Builder pingStatus(PingStatus pingStatus);

        /**
         * <p>
         * The date and time when agent last pinged Systems Manager service.
         * </p>
         * 
         * @param lastPingDateTime
         *        The date and time when agent last pinged Systems Manager service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastPingDateTime(Instant lastPingDateTime);

        /**
         * <p>
         * The version of the SSM Agent running on your Linux instance.
         * </p>
         * 
         * @param agentVersion
         *        The version of the SSM Agent running on your Linux instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * <p>
         * Indicates whether latest version of the SSM Agent is running on your instance.
         * </p>
         * 
         * @param isLatestVersion
         *        Indicates whether latest version of the SSM Agent is running on your instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isLatestVersion(Boolean isLatestVersion);

        /**
         * <p>
         * The operating system platform type.
         * </p>
         * 
         * @param platformType
         *        The operating system platform type.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platformType(String platformType);

        /**
         * <p>
         * The operating system platform type.
         * </p>
         * 
         * @param platformType
         *        The operating system platform type.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platformType(PlatformType platformType);

        /**
         * <p>
         * The name of the operating system platform running on your instance.
         * </p>
         * 
         * @param platformName
         *        The name of the operating system platform running on your instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformName(String platformName);

        /**
         * <p>
         * The version of the OS platform running on your instance.
         * </p>
         * 
         * @param platformVersion
         *        The version of the OS platform running on your instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * <p>
         * The activation ID created by Systems Manager when the server or VM was registered.
         * </p>
         * 
         * @param activationId
         *        The activation ID created by Systems Manager when the server or VM was registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationId(String activationId);

        /**
         * <p>
         * The Amazon Identity and Access Management (IAM) role assigned to EC2 instances or managed instances.
         * </p>
         * 
         * @param iamRole
         *        The Amazon Identity and Access Management (IAM) role assigned to EC2 instances or managed instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRole(String iamRole);

        /**
         * <p>
         * The date the server or VM was registered with AWS as a managed instance.
         * </p>
         * 
         * @param registrationDate
         *        The date the server or VM was registered with AWS as a managed instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationDate(Instant registrationDate);

        /**
         * <p>
         * The type of instance. Instances are either EC2 instances or managed instances.
         * </p>
         * 
         * @param resourceType
         *        The type of instance. Instances are either EC2 instances or managed instances.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of instance. Instances are either EC2 instances or managed instances.
         * </p>
         * 
         * @param resourceType
         *        The type of instance. Instances are either EC2 instances or managed instances.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The name of the managed instance.
         * </p>
         * 
         * @param name
         *        The name of the managed instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The IP address of the managed instance.
         * </p>
         * 
         * @param ipAddress
         *        The IP address of the managed instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The fully qualified host name of the managed instance.
         * </p>
         * 
         * @param computerName
         *        The fully qualified host name of the managed instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computerName(String computerName);

        /**
         * <p>
         * The status of the association.
         * </p>
         * 
         * @param associationStatus
         *        The status of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationStatus(String associationStatus);

        /**
         * <p>
         * The date the association was last executed.
         * </p>
         * 
         * @param lastAssociationExecutionDate
         *        The date the association was last executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAssociationExecutionDate(Instant lastAssociationExecutionDate);

        /**
         * <p>
         * The last date the association was successfully run.
         * </p>
         * 
         * @param lastSuccessfulAssociationExecutionDate
         *        The last date the association was successfully run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulAssociationExecutionDate(Instant lastSuccessfulAssociationExecutionDate);

        /**
         * <p>
         * Information about the association.
         * </p>
         * 
         * @param associationOverview
         *        Information about the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationOverview(InstanceAggregatedAssociationOverview associationOverview);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String pingStatus;

        private Instant lastPingDateTime;

        private String agentVersion;

        private Boolean isLatestVersion;

        private String platformType;

        private String platformName;

        private String platformVersion;

        private String activationId;

        private String iamRole;

        private Instant registrationDate;

        private String resourceType;

        private String name;

        private String ipAddress;

        private String computerName;

        private String associationStatus;

        private Instant lastAssociationExecutionDate;

        private Instant lastSuccessfulAssociationExecutionDate;

        private InstanceAggregatedAssociationOverview associationOverview;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceInformation model) {
            instanceId(model.instanceId);
            pingStatus(model.pingStatus);
            lastPingDateTime(model.lastPingDateTime);
            agentVersion(model.agentVersion);
            isLatestVersion(model.isLatestVersion);
            platformType(model.platformType);
            platformName(model.platformName);
            platformVersion(model.platformVersion);
            activationId(model.activationId);
            iamRole(model.iamRole);
            registrationDate(model.registrationDate);
            resourceType(model.resourceType);
            name(model.name);
            ipAddress(model.ipAddress);
            computerName(model.computerName);
            associationStatus(model.associationStatus);
            lastAssociationExecutionDate(model.lastAssociationExecutionDate);
            lastSuccessfulAssociationExecutionDate(model.lastSuccessfulAssociationExecutionDate);
            associationOverview(model.associationOverview);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPingStatus() {
            return pingStatus;
        }

        @Override
        public final Builder pingStatus(String pingStatus) {
            this.pingStatus = pingStatus;
            return this;
        }

        @Override
        public final Builder pingStatus(PingStatus pingStatus) {
            this.pingStatus(pingStatus.toString());
            return this;
        }

        public final void setPingStatus(String pingStatus) {
            this.pingStatus = pingStatus;
        }

        public final Instant getLastPingDateTime() {
            return lastPingDateTime;
        }

        @Override
        public final Builder lastPingDateTime(Instant lastPingDateTime) {
            this.lastPingDateTime = lastPingDateTime;
            return this;
        }

        public final void setLastPingDateTime(Instant lastPingDateTime) {
            this.lastPingDateTime = lastPingDateTime;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        public final Boolean getIsLatestVersion() {
            return isLatestVersion;
        }

        @Override
        public final Builder isLatestVersion(Boolean isLatestVersion) {
            this.isLatestVersion = isLatestVersion;
            return this;
        }

        public final void setIsLatestVersion(Boolean isLatestVersion) {
            this.isLatestVersion = isLatestVersion;
        }

        public final String getPlatformType() {
            return platformType;
        }

        @Override
        public final Builder platformType(String platformType) {
            this.platformType = platformType;
            return this;
        }

        @Override
        public final Builder platformType(PlatformType platformType) {
            this.platformType(platformType.toString());
            return this;
        }

        public final void setPlatformType(String platformType) {
            this.platformType = platformType;
        }

        public final String getPlatformName() {
            return platformName;
        }

        @Override
        public final Builder platformName(String platformName) {
            this.platformName = platformName;
            return this;
        }

        public final void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final String getActivationId() {
            return activationId;
        }

        @Override
        public final Builder activationId(String activationId) {
            this.activationId = activationId;
            return this;
        }

        public final void setActivationId(String activationId) {
            this.activationId = activationId;
        }

        public final String getIamRole() {
            return iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        public final Instant getRegistrationDate() {
            return registrationDate;
        }

        @Override
        public final Builder registrationDate(Instant registrationDate) {
            this.registrationDate = registrationDate;
            return this;
        }

        public final void setRegistrationDate(Instant registrationDate) {
            this.registrationDate = registrationDate;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getIPAddress() {
            return ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIPAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getComputerName() {
            return computerName;
        }

        @Override
        public final Builder computerName(String computerName) {
            this.computerName = computerName;
            return this;
        }

        public final void setComputerName(String computerName) {
            this.computerName = computerName;
        }

        public final String getAssociationStatus() {
            return associationStatus;
        }

        @Override
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        public final Instant getLastAssociationExecutionDate() {
            return lastAssociationExecutionDate;
        }

        @Override
        public final Builder lastAssociationExecutionDate(Instant lastAssociationExecutionDate) {
            this.lastAssociationExecutionDate = lastAssociationExecutionDate;
            return this;
        }

        public final void setLastAssociationExecutionDate(Instant lastAssociationExecutionDate) {
            this.lastAssociationExecutionDate = lastAssociationExecutionDate;
        }

        public final Instant getLastSuccessfulAssociationExecutionDate() {
            return lastSuccessfulAssociationExecutionDate;
        }

        @Override
        public final Builder lastSuccessfulAssociationExecutionDate(Instant lastSuccessfulAssociationExecutionDate) {
            this.lastSuccessfulAssociationExecutionDate = lastSuccessfulAssociationExecutionDate;
            return this;
        }

        public final void setLastSuccessfulAssociationExecutionDate(Instant lastSuccessfulAssociationExecutionDate) {
            this.lastSuccessfulAssociationExecutionDate = lastSuccessfulAssociationExecutionDate;
        }

        public final InstanceAggregatedAssociationOverview.Builder getAssociationOverview() {
            return associationOverview != null ? associationOverview.toBuilder() : null;
        }

        @Override
        public final Builder associationOverview(InstanceAggregatedAssociationOverview associationOverview) {
            this.associationOverview = associationOverview;
            return this;
        }

        public final void setAssociationOverview(InstanceAggregatedAssociationOverview.BuilderImpl associationOverview) {
            this.associationOverview = associationOverview != null ? associationOverview.build() : null;
        }

        @Override
        public InstanceInformation build() {
            return new InstanceInformation(this);
        }
    }
}
