/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListCommandInvocationsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListCommandInvocationsRequest.Builder, ListCommandInvocationsRequest> {
    private final String commandId;

    private final String instanceId;

    private final Integer maxResults;

    private final String nextToken;

    private final List<CommandFilter> filters;

    private final Boolean details;

    private ListCommandInvocationsRequest(BuilderImpl builder) {
        this.commandId = builder.commandId;
        this.instanceId = builder.instanceId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
        this.details = builder.details;
    }

    /**
     * <p>
     * (Optional) The invocations for a specific command ID.
     * </p>
     * 
     * @return (Optional) The invocations for a specific command ID.
     */
    public String commandId() {
        return commandId;
    }

    /**
     * <p>
     * (Optional) The command execution details for a specific instance ID.
     * </p>
     * 
     * @return (Optional) The command execution details for a specific instance ID.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * (Optional) The maximum number of items to return for this call. The call also returns a token that you can
     * specify in a subsequent call to get the next set of results.
     * </p>
     * 
     * @return (Optional) The maximum number of items to return for this call. The call also returns a token that you
     *         can specify in a subsequent call to get the next set of results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * (Optional) The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return (Optional) The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * (Optional) One or more filters. Use a filter to return a more specific list of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Optional) One or more filters. Use a filter to return a more specific list of results.
     */
    public List<CommandFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * (Optional) If set this returns the response of the command executions and any command output. By default this is
     * set to False.
     * </p>
     * 
     * @return (Optional) If set this returns the response of the command executions and any command output. By default
     *         this is set to False.
     */
    public Boolean details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((commandId() == null) ? 0 : commandId().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((details() == null) ? 0 : details().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommandInvocationsRequest)) {
            return false;
        }
        ListCommandInvocationsRequest other = (ListCommandInvocationsRequest) obj;
        if (other.commandId() == null ^ this.commandId() == null) {
            return false;
        }
        if (other.commandId() != null && !other.commandId().equals(this.commandId())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.details() == null ^ this.details() == null) {
            return false;
        }
        if (other.details() != null && !other.details().equals(this.details())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (commandId() != null) {
            sb.append("CommandId: ").append(commandId()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (details() != null) {
            sb.append("Details: ").append(details()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CommandId":
            return Optional.of(clazz.cast(commandId()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "Details":
            return Optional.of(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListCommandInvocationsRequest> {
        /**
         * <p>
         * (Optional) The invocations for a specific command ID.
         * </p>
         * 
         * @param commandId
         *        (Optional) The invocations for a specific command ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandId(String commandId);

        /**
         * <p>
         * (Optional) The command execution details for a specific instance ID.
         * </p>
         * 
         * @param instanceId
         *        (Optional) The command execution details for a specific instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * (Optional) The maximum number of items to return for this call. The call also returns a token that you can
         * specify in a subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        (Optional) The maximum number of items to return for this call. The call also returns a token that you
         *        can specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * (Optional) The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        (Optional) The token for the next set of items to return. (You received this token from a previous
         *        call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * (Optional) One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param filters
         *        (Optional) One or more filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<CommandFilter> filters);

        /**
         * <p>
         * (Optional) One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param filters
         *        (Optional) One or more filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(CommandFilter... filters);

        /**
         * <p>
         * (Optional) If set this returns the response of the command executions and any command output. By default this
         * is set to False.
         * </p>
         * 
         * @param details
         *        (Optional) If set this returns the response of the command executions and any command output. By
         *        default this is set to False.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Boolean details);
    }

    static final class BuilderImpl implements Builder {
        private String commandId;

        private String instanceId;

        private Integer maxResults;

        private String nextToken;

        private List<CommandFilter> filters;

        private Boolean details;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCommandInvocationsRequest model) {
            commandId(model.commandId);
            instanceId(model.instanceId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            filters(model.filters);
            details(model.details);
        }

        public final String getCommandId() {
            return commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<CommandFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(CommandFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<CommandFilter> filters) {
            this.filters = CommandFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(CommandFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<CommandFilter.BuilderImpl> filters) {
            this.filters = CommandFilterListCopier.copyFromBuilder(filters);
        }

        public final Boolean getDetails() {
            return details;
        }

        @Override
        public final Builder details(Boolean details) {
            this.details = details;
            return this;
        }

        public final void setDetails(Boolean details) {
            this.details = details;
        }

        @Override
        public ListCommandInvocationsRequest build() {
            return new ListCommandInvocationsRequest(this);
        }
    }
}
