/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListCommandsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListCommandsResponse.Builder, ListCommandsResponse> {
    private final List<Command> commands;

    private final String nextToken;

    private ListCommandsResponse(BuilderImpl builder) {
        this.commands = builder.commands;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * (Optional) The list of commands requested by the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Optional) The list of commands requested by the user.
     */
    public List<Command> commands() {
        return commands;
    }

    /**
     * <p>
     * (Optional) The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return (Optional) The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((commands() == null) ? 0 : commands().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommandsResponse)) {
            return false;
        }
        ListCommandsResponse other = (ListCommandsResponse) obj;
        if (other.commands() == null ^ this.commands() == null) {
            return false;
        }
        if (other.commands() != null && !other.commands().equals(this.commands())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (commands() != null) {
            sb.append("Commands: ").append(commands()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Commands":
            return Optional.of(clazz.cast(commands()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListCommandsResponse> {
        /**
         * <p>
         * (Optional) The list of commands requested by the user.
         * </p>
         * 
         * @param commands
         *        (Optional) The list of commands requested by the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commands(Collection<Command> commands);

        /**
         * <p>
         * (Optional) The list of commands requested by the user.
         * </p>
         * 
         * @param commands
         *        (Optional) The list of commands requested by the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commands(Command... commands);

        /**
         * <p>
         * (Optional) The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        (Optional) The token for the next set of items to return. (You received this token from a previous
         *        call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<Command> commands;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCommandsResponse model) {
            commands(model.commands);
            nextToken(model.nextToken);
        }

        public final Collection<Command.Builder> getCommands() {
            return commands != null ? commands.stream().map(Command::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder commands(Collection<Command> commands) {
            this.commands = CommandListCopier.copy(commands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commands(Command... commands) {
            commands(Arrays.asList(commands));
            return this;
        }

        public final void setCommands(Collection<Command.BuilderImpl> commands) {
            this.commands = CommandListCopier.copyFromBuilder(commands);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCommandsResponse build() {
            return new ListCommandsResponse(this);
        }
    }
}
