/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.PatchBaselineIdentityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the basic information about a patch baseline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PatchBaselineIdentity implements StructuredPojo,
        ToCopyableBuilder<PatchBaselineIdentity.Builder, PatchBaselineIdentity> {
    private final String baselineId;

    private final String baselineName;

    private final String baselineDescription;

    private final Boolean defaultBaseline;

    private PatchBaselineIdentity(BuilderImpl builder) {
        this.baselineId = builder.baselineId;
        this.baselineName = builder.baselineName;
        this.baselineDescription = builder.baselineDescription;
        this.defaultBaseline = builder.defaultBaseline;
    }

    /**
     * <p>
     * The ID of the patch baseline.
     * </p>
     * 
     * @return The ID of the patch baseline.
     */
    public String baselineId() {
        return baselineId;
    }

    /**
     * <p>
     * The name of the patch baseline.
     * </p>
     * 
     * @return The name of the patch baseline.
     */
    public String baselineName() {
        return baselineName;
    }

    /**
     * <p>
     * The description of the patch baseline.
     * </p>
     * 
     * @return The description of the patch baseline.
     */
    public String baselineDescription() {
        return baselineDescription;
    }

    /**
     * <p>
     * Whether this is the default baseline.
     * </p>
     * 
     * @return Whether this is the default baseline.
     */
    public Boolean defaultBaseline() {
        return defaultBaseline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((baselineId() == null) ? 0 : baselineId().hashCode());
        hashCode = 31 * hashCode + ((baselineName() == null) ? 0 : baselineName().hashCode());
        hashCode = 31 * hashCode + ((baselineDescription() == null) ? 0 : baselineDescription().hashCode());
        hashCode = 31 * hashCode + ((defaultBaseline() == null) ? 0 : defaultBaseline().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchBaselineIdentity)) {
            return false;
        }
        PatchBaselineIdentity other = (PatchBaselineIdentity) obj;
        if (other.baselineId() == null ^ this.baselineId() == null) {
            return false;
        }
        if (other.baselineId() != null && !other.baselineId().equals(this.baselineId())) {
            return false;
        }
        if (other.baselineName() == null ^ this.baselineName() == null) {
            return false;
        }
        if (other.baselineName() != null && !other.baselineName().equals(this.baselineName())) {
            return false;
        }
        if (other.baselineDescription() == null ^ this.baselineDescription() == null) {
            return false;
        }
        if (other.baselineDescription() != null && !other.baselineDescription().equals(this.baselineDescription())) {
            return false;
        }
        if (other.defaultBaseline() == null ^ this.defaultBaseline() == null) {
            return false;
        }
        if (other.defaultBaseline() != null && !other.defaultBaseline().equals(this.defaultBaseline())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (baselineId() != null) {
            sb.append("BaselineId: ").append(baselineId()).append(",");
        }
        if (baselineName() != null) {
            sb.append("BaselineName: ").append(baselineName()).append(",");
        }
        if (baselineDescription() != null) {
            sb.append("BaselineDescription: ").append(baselineDescription()).append(",");
        }
        if (defaultBaseline() != null) {
            sb.append("DefaultBaseline: ").append(defaultBaseline()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaselineId":
            return Optional.of(clazz.cast(baselineId()));
        case "BaselineName":
            return Optional.of(clazz.cast(baselineName()));
        case "BaselineDescription":
            return Optional.of(clazz.cast(baselineDescription()));
        case "DefaultBaseline":
            return Optional.of(clazz.cast(defaultBaseline()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchBaselineIdentityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, PatchBaselineIdentity> {
        /**
         * <p>
         * The ID of the patch baseline.
         * </p>
         * 
         * @param baselineId
         *        The ID of the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineId(String baselineId);

        /**
         * <p>
         * The name of the patch baseline.
         * </p>
         * 
         * @param baselineName
         *        The name of the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineName(String baselineName);

        /**
         * <p>
         * The description of the patch baseline.
         * </p>
         * 
         * @param baselineDescription
         *        The description of the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineDescription(String baselineDescription);

        /**
         * <p>
         * Whether this is the default baseline.
         * </p>
         * 
         * @param defaultBaseline
         *        Whether this is the default baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultBaseline(Boolean defaultBaseline);
    }

    static final class BuilderImpl implements Builder {
        private String baselineId;

        private String baselineName;

        private String baselineDescription;

        private Boolean defaultBaseline;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchBaselineIdentity model) {
            baselineId(model.baselineId);
            baselineName(model.baselineName);
            baselineDescription(model.baselineDescription);
            defaultBaseline(model.defaultBaseline);
        }

        public final String getBaselineId() {
            return baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        public final String getBaselineName() {
            return baselineName;
        }

        @Override
        public final Builder baselineName(String baselineName) {
            this.baselineName = baselineName;
            return this;
        }

        public final void setBaselineName(String baselineName) {
            this.baselineName = baselineName;
        }

        public final String getBaselineDescription() {
            return baselineDescription;
        }

        @Override
        public final Builder baselineDescription(String baselineDescription) {
            this.baselineDescription = baselineDescription;
            return this;
        }

        public final void setBaselineDescription(String baselineDescription) {
            this.baselineDescription = baselineDescription;
        }

        public final Boolean getDefaultBaseline() {
            return defaultBaseline;
        }

        @Override
        public final Builder defaultBaseline(Boolean defaultBaseline) {
            this.defaultBaseline = defaultBaseline;
            return this;
        }

        public final void setDefaultBaseline(Boolean defaultBaseline) {
            this.defaultBaseline = defaultBaseline;
        }

        @Override
        public PatchBaselineIdentity build() {
            return new PatchBaselineIdentity(this);
        }
    }
}
