/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.PatchRuleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines an approval rule for a patch baseline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PatchRule implements StructuredPojo, ToCopyableBuilder<PatchRule.Builder, PatchRule> {
    private final PatchFilterGroup patchFilterGroup;

    private final Integer approveAfterDays;

    private PatchRule(BuilderImpl builder) {
        this.patchFilterGroup = builder.patchFilterGroup;
        this.approveAfterDays = builder.approveAfterDays;
    }

    /**
     * <p>
     * The patch filter group that defines the criteria for the rule.
     * </p>
     * 
     * @return The patch filter group that defines the criteria for the rule.
     */
    public PatchFilterGroup patchFilterGroup() {
        return patchFilterGroup;
    }

    /**
     * <p>
     * The number of days after the release date of each patch matched by the rule the patch is marked as approved in
     * the patch baseline.
     * </p>
     * 
     * @return The number of days after the release date of each patch matched by the rule the patch is marked as
     *         approved in the patch baseline.
     */
    public Integer approveAfterDays() {
        return approveAfterDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((patchFilterGroup() == null) ? 0 : patchFilterGroup().hashCode());
        hashCode = 31 * hashCode + ((approveAfterDays() == null) ? 0 : approveAfterDays().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchRule)) {
            return false;
        }
        PatchRule other = (PatchRule) obj;
        if (other.patchFilterGroup() == null ^ this.patchFilterGroup() == null) {
            return false;
        }
        if (other.patchFilterGroup() != null && !other.patchFilterGroup().equals(this.patchFilterGroup())) {
            return false;
        }
        if (other.approveAfterDays() == null ^ this.approveAfterDays() == null) {
            return false;
        }
        if (other.approveAfterDays() != null && !other.approveAfterDays().equals(this.approveAfterDays())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (patchFilterGroup() != null) {
            sb.append("PatchFilterGroup: ").append(patchFilterGroup()).append(",");
        }
        if (approveAfterDays() != null) {
            sb.append("ApproveAfterDays: ").append(approveAfterDays()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PatchFilterGroup":
            return Optional.of(clazz.cast(patchFilterGroup()));
        case "ApproveAfterDays":
            return Optional.of(clazz.cast(approveAfterDays()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, PatchRule> {
        /**
         * <p>
         * The patch filter group that defines the criteria for the rule.
         * </p>
         * 
         * @param patchFilterGroup
         *        The patch filter group that defines the criteria for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchFilterGroup(PatchFilterGroup patchFilterGroup);

        /**
         * <p>
         * The number of days after the release date of each patch matched by the rule the patch is marked as approved
         * in the patch baseline.
         * </p>
         * 
         * @param approveAfterDays
         *        The number of days after the release date of each patch matched by the rule the patch is marked as
         *        approved in the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approveAfterDays(Integer approveAfterDays);
    }

    static final class BuilderImpl implements Builder {
        private PatchFilterGroup patchFilterGroup;

        private Integer approveAfterDays;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchRule model) {
            patchFilterGroup(model.patchFilterGroup);
            approveAfterDays(model.approveAfterDays);
        }

        public final PatchFilterGroup.Builder getPatchFilterGroup() {
            return patchFilterGroup != null ? patchFilterGroup.toBuilder() : null;
        }

        @Override
        public final Builder patchFilterGroup(PatchFilterGroup patchFilterGroup) {
            this.patchFilterGroup = patchFilterGroup;
            return this;
        }

        public final void setPatchFilterGroup(PatchFilterGroup.BuilderImpl patchFilterGroup) {
            this.patchFilterGroup = patchFilterGroup != null ? patchFilterGroup.build() : null;
        }

        public final Integer getApproveAfterDays() {
            return approveAfterDays;
        }

        @Override
        public final Builder approveAfterDays(Integer approveAfterDays) {
            this.approveAfterDays = approveAfterDays;
            return this;
        }

        public final void setApproveAfterDays(Integer approveAfterDays) {
            this.approveAfterDays = approveAfterDays;
        }

        @Override
        public PatchRule build() {
            return new PatchRule(this);
        }
    }
}
