/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.ResultAttributeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The inventory item result attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ResultAttribute implements StructuredPojo, ToCopyableBuilder<ResultAttribute.Builder, ResultAttribute> {
    private final String typeName;

    private ResultAttribute(BuilderImpl builder) {
        this.typeName = builder.typeName;
    }

    /**
     * <p>
     * Name of the inventory item type. Valid value: AWS:InstanceInformation. Default Value: AWS:InstanceInformation.
     * </p>
     * 
     * @return Name of the inventory item type. Valid value: AWS:InstanceInformation. Default Value:
     *         AWS:InstanceInformation.
     */
    public String typeName() {
        return typeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((typeName() == null) ? 0 : typeName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultAttribute)) {
            return false;
        }
        ResultAttribute other = (ResultAttribute) obj;
        if (other.typeName() == null ^ this.typeName() == null) {
            return false;
        }
        if (other.typeName() != null && !other.typeName().equals(this.typeName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (typeName() != null) {
            sb.append("TypeName: ").append(typeName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeName":
            return Optional.of(clazz.cast(typeName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResultAttributeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ResultAttribute> {
        /**
         * <p>
         * Name of the inventory item type. Valid value: AWS:InstanceInformation. Default Value:
         * AWS:InstanceInformation.
         * </p>
         * 
         * @param typeName
         *        Name of the inventory item type. Valid value: AWS:InstanceInformation. Default Value:
         *        AWS:InstanceInformation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);
    }

    static final class BuilderImpl implements Builder {
        private String typeName;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultAttribute model) {
            typeName(model.typeName);
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public ResultAttribute build() {
            return new ResultAttribute(this);
        }
    }
}
