/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDocumentRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateDocumentRequest.Builder, UpdateDocumentRequest> {
    private final String content;

    private final String name;

    private final String documentVersion;

    private UpdateDocumentRequest(BuilderImpl builder) {
        this.content = builder.content;
        this.name = builder.name;
        this.documentVersion = builder.documentVersion;
    }

    /**
     * <p>
     * The content in a document that you want to update.
     * </p>
     * 
     * @return The content in a document that you want to update.
     */
    public String content() {
        return content;
    }

    /**
     * <p>
     * The name of the document that you want to update.
     * </p>
     * 
     * @return The name of the document that you want to update.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The version of the document that you want to update.
     * </p>
     * 
     * @return The version of the document that you want to update.
     */
    public String documentVersion() {
        return documentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((content() == null) ? 0 : content().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((documentVersion() == null) ? 0 : documentVersion().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDocumentRequest)) {
            return false;
        }
        UpdateDocumentRequest other = (UpdateDocumentRequest) obj;
        if (other.content() == null ^ this.content() == null) {
            return false;
        }
        if (other.content() != null && !other.content().equals(this.content())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.documentVersion() == null ^ this.documentVersion() == null) {
            return false;
        }
        if (other.documentVersion() != null && !other.documentVersion().equals(this.documentVersion())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (content() != null) {
            sb.append("Content: ").append(content()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (documentVersion() != null) {
            sb.append("DocumentVersion: ").append(documentVersion()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Content":
            return Optional.of(clazz.cast(content()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "DocumentVersion":
            return Optional.of(clazz.cast(documentVersion()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateDocumentRequest> {
        /**
         * <p>
         * The content in a document that you want to update.
         * </p>
         * 
         * @param content
         *        The content in a document that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The name of the document that you want to update.
         * </p>
         * 
         * @param name
         *        The name of the document that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of the document that you want to update.
         * </p>
         * 
         * @param documentVersion
         *        The version of the document that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);
    }

    static final class BuilderImpl implements Builder {
        private String content;

        private String name;

        private String documentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDocumentRequest model) {
            content(model.content);
            name(model.name);
            documentVersion(model.documentVersion);
        }

        public final String getContent() {
            return content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        public UpdateDocumentRequest build() {
            return new UpdateDocumentRequest(this);
        }
    }
}
