/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.ssm.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * InstanceAssociationStatusInfo JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class InstanceAssociationStatusInfoUnmarshaller implements
        Unmarshaller<InstanceAssociationStatusInfo, JsonUnmarshallerContext> {

    public InstanceAssociationStatusInfo unmarshall(JsonUnmarshallerContext context) throws Exception {
        InstanceAssociationStatusInfo.Builder instanceAssociationStatusInfoBuilder = InstanceAssociationStatusInfo.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("AssociationId", targetDepth)) {
                    context.nextToken();
                    instanceAssociationStatusInfoBuilder.associationId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    instanceAssociationStatusInfoBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DocumentVersion", targetDepth)) {
                    context.nextToken();
                    instanceAssociationStatusInfoBuilder.documentVersion(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("InstanceId", targetDepth)) {
                    context.nextToken();
                    instanceAssociationStatusInfoBuilder.instanceId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ExecutionDate", targetDepth)) {
                    context.nextToken();
                    instanceAssociationStatusInfoBuilder.executionDate(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    instanceAssociationStatusInfoBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DetailedStatus", targetDepth)) {
                    context.nextToken();
                    instanceAssociationStatusInfoBuilder
                            .detailedStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ExecutionSummary", targetDepth)) {
                    context.nextToken();
                    instanceAssociationStatusInfoBuilder.executionSummary(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("ErrorCode", targetDepth)) {
                    context.nextToken();
                    instanceAssociationStatusInfoBuilder.errorCode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("OutputUrl", targetDepth)) {
                    context.nextToken();
                    instanceAssociationStatusInfoBuilder.outputUrl(InstanceAssociationOutputUrlUnmarshaller.getInstance()
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return instanceAssociationStatusInfoBuilder.build();
    }

    private static final InstanceAssociationStatusInfoUnmarshaller INSTANCE = new InstanceAssociationStatusInfoUnmarshaller();

    public static InstanceAssociationStatusInfoUnmarshaller getInstance() {
        return INSTANCE;
    }
}
