/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.EffectivePatch;
import software.amazon.awssdk.services.ssm.model.EffectivePatchListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEffectivePatchesForPatchBaselineResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeEffectivePatchesForPatchBaselineResponse> {
    private final List<EffectivePatch> effectivePatches;
    private final String nextToken;

    private DescribeEffectivePatchesForPatchBaselineResponse(BuilderImpl builder) {
        this.effectivePatches = builder.effectivePatches;
        this.nextToken = builder.nextToken;
    }

    public List<EffectivePatch> effectivePatches() {
        return this.effectivePatches;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.effectivePatches() == null ? 0 : this.effectivePatches().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEffectivePatchesForPatchBaselineResponse)) {
            return false;
        }
        DescribeEffectivePatchesForPatchBaselineResponse other = (DescribeEffectivePatchesForPatchBaselineResponse)((Object)obj);
        if (other.effectivePatches() == null ^ this.effectivePatches() == null) {
            return false;
        }
        if (other.effectivePatches() != null && !other.effectivePatches().equals(this.effectivePatches())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.effectivePatches() != null) {
            sb.append("EffectivePatches: ").append(this.effectivePatches()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EffectivePatches": {
                return Optional.of(clazz.cast(this.effectivePatches()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<EffectivePatch> effectivePatches;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEffectivePatchesForPatchBaselineResponse model) {
            this.effectivePatches(model.effectivePatches);
            this.nextToken(model.nextToken);
        }

        public final Collection<EffectivePatch.Builder> getEffectivePatches() {
            return this.effectivePatches != null ? (Collection)this.effectivePatches.stream().map(EffectivePatch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder effectivePatches(Collection<EffectivePatch> effectivePatches) {
            this.effectivePatches = EffectivePatchListCopier.copy(effectivePatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectivePatches(EffectivePatch ... effectivePatches) {
            this.effectivePatches(Arrays.asList(effectivePatches));
            return this;
        }

        public final void setEffectivePatches(Collection<EffectivePatch.BuilderImpl> effectivePatches) {
            this.effectivePatches = EffectivePatchListCopier.copyFromBuilder(effectivePatches);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeEffectivePatchesForPatchBaselineResponse build() {
            return new DescribeEffectivePatchesForPatchBaselineResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEffectivePatchesForPatchBaselineResponse> {
        public Builder effectivePatches(Collection<EffectivePatch> var1);

        public Builder effectivePatches(EffectivePatch ... var1);

        public Builder nextToken(String var1);
    }
}

