/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.InstancePatchState;
import software.amazon.awssdk.services.ssm.model.InstancePatchStateListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstancePatchStatesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeInstancePatchStatesResponse> {
    private final List<InstancePatchState> instancePatchStates;
    private final String nextToken;

    private DescribeInstancePatchStatesResponse(BuilderImpl builder) {
        this.instancePatchStates = builder.instancePatchStates;
        this.nextToken = builder.nextToken;
    }

    public List<InstancePatchState> instancePatchStates() {
        return this.instancePatchStates;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instancePatchStates() == null ? 0 : this.instancePatchStates().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancePatchStatesResponse)) {
            return false;
        }
        DescribeInstancePatchStatesResponse other = (DescribeInstancePatchStatesResponse)((Object)obj);
        if (other.instancePatchStates() == null ^ this.instancePatchStates() == null) {
            return false;
        }
        if (other.instancePatchStates() != null && !other.instancePatchStates().equals(this.instancePatchStates())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instancePatchStates() != null) {
            sb.append("InstancePatchStates: ").append(this.instancePatchStates()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstancePatchStates": {
                return Optional.of(clazz.cast(this.instancePatchStates()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<InstancePatchState> instancePatchStates;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancePatchStatesResponse model) {
            this.instancePatchStates(model.instancePatchStates);
            this.nextToken(model.nextToken);
        }

        public final Collection<InstancePatchState.Builder> getInstancePatchStates() {
            return this.instancePatchStates != null ? (Collection)this.instancePatchStates.stream().map(InstancePatchState::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instancePatchStates(Collection<InstancePatchState> instancePatchStates) {
            this.instancePatchStates = InstancePatchStateListCopier.copy(instancePatchStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancePatchStates(InstancePatchState ... instancePatchStates) {
            this.instancePatchStates(Arrays.asList(instancePatchStates));
            return this;
        }

        public final void setInstancePatchStates(Collection<InstancePatchState.BuilderImpl> instancePatchStates) {
            this.instancePatchStates = InstancePatchStateListCopier.copyFromBuilder(instancePatchStates);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeInstancePatchStatesResponse build() {
            return new DescribeInstancePatchStatesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInstancePatchStatesResponse> {
        public Builder instancePatchStates(Collection<InstancePatchState> var1);

        public Builder instancePatchStates(InstancePatchState ... var1);

        public Builder nextToken(String var1);
    }
}

