/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowIdentity;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowIdentityListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMaintenanceWindowsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeMaintenanceWindowsResponse> {
    private final List<MaintenanceWindowIdentity> windowIdentities;
    private final String nextToken;

    private DescribeMaintenanceWindowsResponse(BuilderImpl builder) {
        this.windowIdentities = builder.windowIdentities;
        this.nextToken = builder.nextToken;
    }

    public List<MaintenanceWindowIdentity> windowIdentities() {
        return this.windowIdentities;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.windowIdentities() == null ? 0 : this.windowIdentities().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowsResponse)) {
            return false;
        }
        DescribeMaintenanceWindowsResponse other = (DescribeMaintenanceWindowsResponse)((Object)obj);
        if (other.windowIdentities() == null ^ this.windowIdentities() == null) {
            return false;
        }
        if (other.windowIdentities() != null && !other.windowIdentities().equals(this.windowIdentities())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.windowIdentities() != null) {
            sb.append("WindowIdentities: ").append(this.windowIdentities()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowIdentities": {
                return Optional.of(clazz.cast(this.windowIdentities()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<MaintenanceWindowIdentity> windowIdentities;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowsResponse model) {
            this.windowIdentities(model.windowIdentities);
            this.nextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowIdentity.Builder> getWindowIdentities() {
            return this.windowIdentities != null ? (Collection)this.windowIdentities.stream().map(MaintenanceWindowIdentity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder windowIdentities(Collection<MaintenanceWindowIdentity> windowIdentities) {
            this.windowIdentities = MaintenanceWindowIdentityListCopier.copy(windowIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowIdentities(MaintenanceWindowIdentity ... windowIdentities) {
            this.windowIdentities(Arrays.asList(windowIdentities));
            return this;
        }

        public final void setWindowIdentities(Collection<MaintenanceWindowIdentity.BuilderImpl> windowIdentities) {
            this.windowIdentities = MaintenanceWindowIdentityListCopier.copyFromBuilder(windowIdentities);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeMaintenanceWindowsResponse build() {
            return new DescribeMaintenanceWindowsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeMaintenanceWindowsResponse> {
        public Builder windowIdentities(Collection<MaintenanceWindowIdentity> var1);

        public Builder windowIdentities(MaintenanceWindowIdentity ... var1);

        public Builder nextToken(String var1);
    }
}

