/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDeployablePatchSnapshotForInstanceResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetDeployablePatchSnapshotForInstanceResponse> {
    private final String instanceId;
    private final String snapshotId;
    private final String snapshotDownloadUrl;

    private GetDeployablePatchSnapshotForInstanceResponse(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.snapshotId = builder.snapshotId;
        this.snapshotDownloadUrl = builder.snapshotDownloadUrl;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public String snapshotDownloadUrl() {
        return this.snapshotDownloadUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.snapshotId() == null ? 0 : this.snapshotId().hashCode());
        hashCode = 31 * hashCode + (this.snapshotDownloadUrl() == null ? 0 : this.snapshotDownloadUrl().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeployablePatchSnapshotForInstanceResponse)) {
            return false;
        }
        GetDeployablePatchSnapshotForInstanceResponse other = (GetDeployablePatchSnapshotForInstanceResponse)((Object)obj);
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.snapshotId() == null ^ this.snapshotId() == null) {
            return false;
        }
        if (other.snapshotId() != null && !other.snapshotId().equals(this.snapshotId())) {
            return false;
        }
        if (other.snapshotDownloadUrl() == null ^ this.snapshotDownloadUrl() == null) {
            return false;
        }
        return other.snapshotDownloadUrl() == null || other.snapshotDownloadUrl().equals(this.snapshotDownloadUrl());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.snapshotId() != null) {
            sb.append("SnapshotId: ").append(this.snapshotId()).append(",");
        }
        if (this.snapshotDownloadUrl() != null) {
            sb.append("SnapshotDownloadUrl: ").append(this.snapshotDownloadUrl()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "SnapshotId": {
                return Optional.of(clazz.cast(this.snapshotId()));
            }
            case "SnapshotDownloadUrl": {
                return Optional.of(clazz.cast(this.snapshotDownloadUrl()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String snapshotId;
        private String snapshotDownloadUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeployablePatchSnapshotForInstanceResponse model) {
            this.instanceId(model.instanceId);
            this.snapshotId(model.snapshotId);
            this.snapshotDownloadUrl(model.snapshotDownloadUrl);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getSnapshotDownloadUrl() {
            return this.snapshotDownloadUrl;
        }

        @Override
        public final Builder snapshotDownloadUrl(String snapshotDownloadUrl) {
            this.snapshotDownloadUrl = snapshotDownloadUrl;
            return this;
        }

        public final void setSnapshotDownloadUrl(String snapshotDownloadUrl) {
            this.snapshotDownloadUrl = snapshotDownloadUrl;
        }

        public GetDeployablePatchSnapshotForInstanceResponse build() {
            return new GetDeployablePatchSnapshotForInstanceResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetDeployablePatchSnapshotForInstanceResponse> {
        public Builder instanceId(String var1);

        public Builder snapshotId(String var1);

        public Builder snapshotDownloadUrl(String var1);
    }
}

