/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.InventoryItemSchema;
import software.amazon.awssdk.services.ssm.model.InventoryItemSchemaResultListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetInventorySchemaResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetInventorySchemaResponse> {
    private final List<InventoryItemSchema> schemas;
    private final String nextToken;

    private GetInventorySchemaResponse(BuilderImpl builder) {
        this.schemas = builder.schemas;
        this.nextToken = builder.nextToken;
    }

    public List<InventoryItemSchema> schemas() {
        return this.schemas;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.schemas() == null ? 0 : this.schemas().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInventorySchemaResponse)) {
            return false;
        }
        GetInventorySchemaResponse other = (GetInventorySchemaResponse)((Object)obj);
        if (other.schemas() == null ^ this.schemas() == null) {
            return false;
        }
        if (other.schemas() != null && !other.schemas().equals(this.schemas())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.schemas() != null) {
            sb.append("Schemas: ").append(this.schemas()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Schemas": {
                return Optional.of(clazz.cast(this.schemas()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<InventoryItemSchema> schemas;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInventorySchemaResponse model) {
            this.schemas(model.schemas);
            this.nextToken(model.nextToken);
        }

        public final Collection<InventoryItemSchema.Builder> getSchemas() {
            return this.schemas != null ? (Collection)this.schemas.stream().map(InventoryItemSchema::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder schemas(Collection<InventoryItemSchema> schemas) {
            this.schemas = InventoryItemSchemaResultListCopier.copy(schemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(InventoryItemSchema ... schemas) {
            this.schemas(Arrays.asList(schemas));
            return this;
        }

        public final void setSchemas(Collection<InventoryItemSchema.BuilderImpl> schemas) {
            this.schemas = InventoryItemSchemaResultListCopier.copyFromBuilder(schemas);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public GetInventorySchemaResponse build() {
            return new GetInventorySchemaResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetInventorySchemaResponse> {
        public Builder schemas(Collection<InventoryItemSchema> var1);

        public Builder schemas(InventoryItemSchema ... var1);

        public Builder nextToken(String var1);
    }
}

