/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationOutputUrl;
import software.amazon.awssdk.services.ssm.transform.InstanceAssociationStatusInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceAssociationStatusInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceAssociationStatusInfo> {
    private final String associationId;
    private final String name;
    private final String documentVersion;
    private final String instanceId;
    private final Instant executionDate;
    private final String status;
    private final String detailedStatus;
    private final String executionSummary;
    private final String errorCode;
    private final InstanceAssociationOutputUrl outputUrl;

    private InstanceAssociationStatusInfo(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.name = builder.name;
        this.documentVersion = builder.documentVersion;
        this.instanceId = builder.instanceId;
        this.executionDate = builder.executionDate;
        this.status = builder.status;
        this.detailedStatus = builder.detailedStatus;
        this.executionSummary = builder.executionSummary;
        this.errorCode = builder.errorCode;
        this.outputUrl = builder.outputUrl;
    }

    public String associationId() {
        return this.associationId;
    }

    public String name() {
        return this.name;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Instant executionDate() {
        return this.executionDate;
    }

    public String status() {
        return this.status;
    }

    public String detailedStatus() {
        return this.detailedStatus;
    }

    public String executionSummary() {
        return this.executionSummary;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public InstanceAssociationOutputUrl outputUrl() {
        return this.outputUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.associationId() == null ? 0 : this.associationId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.documentVersion() == null ? 0 : this.documentVersion().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.executionDate() == null ? 0 : this.executionDate().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.detailedStatus() == null ? 0 : this.detailedStatus().hashCode());
        hashCode = 31 * hashCode + (this.executionSummary() == null ? 0 : this.executionSummary().hashCode());
        hashCode = 31 * hashCode + (this.errorCode() == null ? 0 : this.errorCode().hashCode());
        hashCode = 31 * hashCode + (this.outputUrl() == null ? 0 : this.outputUrl().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAssociationStatusInfo)) {
            return false;
        }
        InstanceAssociationStatusInfo other = (InstanceAssociationStatusInfo)obj;
        if (other.associationId() == null ^ this.associationId() == null) {
            return false;
        }
        if (other.associationId() != null && !other.associationId().equals(this.associationId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.documentVersion() == null ^ this.documentVersion() == null) {
            return false;
        }
        if (other.documentVersion() != null && !other.documentVersion().equals(this.documentVersion())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.executionDate() == null ^ this.executionDate() == null) {
            return false;
        }
        if (other.executionDate() != null && !other.executionDate().equals(this.executionDate())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.detailedStatus() == null ^ this.detailedStatus() == null) {
            return false;
        }
        if (other.detailedStatus() != null && !other.detailedStatus().equals(this.detailedStatus())) {
            return false;
        }
        if (other.executionSummary() == null ^ this.executionSummary() == null) {
            return false;
        }
        if (other.executionSummary() != null && !other.executionSummary().equals(this.executionSummary())) {
            return false;
        }
        if (other.errorCode() == null ^ this.errorCode() == null) {
            return false;
        }
        if (other.errorCode() != null && !other.errorCode().equals(this.errorCode())) {
            return false;
        }
        if (other.outputUrl() == null ^ this.outputUrl() == null) {
            return false;
        }
        return other.outputUrl() == null || other.outputUrl().equals(this.outputUrl());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.associationId() != null) {
            sb.append("AssociationId: ").append(this.associationId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.documentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.documentVersion()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.executionDate() != null) {
            sb.append("ExecutionDate: ").append(this.executionDate()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.detailedStatus() != null) {
            sb.append("DetailedStatus: ").append(this.detailedStatus()).append(",");
        }
        if (this.executionSummary() != null) {
            sb.append("ExecutionSummary: ").append(this.executionSummary()).append(",");
        }
        if (this.errorCode() != null) {
            sb.append("ErrorCode: ").append(this.errorCode()).append(",");
        }
        if (this.outputUrl() != null) {
            sb.append("OutputUrl: ").append(this.outputUrl()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.of(clazz.cast(this.associationId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "DocumentVersion": {
                return Optional.of(clazz.cast(this.documentVersion()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "ExecutionDate": {
                return Optional.of(clazz.cast(this.executionDate()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "DetailedStatus": {
                return Optional.of(clazz.cast(this.detailedStatus()));
            }
            case "ExecutionSummary": {
                return Optional.of(clazz.cast(this.executionSummary()));
            }
            case "ErrorCode": {
                return Optional.of(clazz.cast(this.errorCode()));
            }
            case "OutputUrl": {
                return Optional.of(clazz.cast(this.outputUrl()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceAssociationStatusInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String name;
        private String documentVersion;
        private String instanceId;
        private Instant executionDate;
        private String status;
        private String detailedStatus;
        private String executionSummary;
        private String errorCode;
        private InstanceAssociationOutputUrl outputUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAssociationStatusInfo model) {
            this.associationId(model.associationId);
            this.name(model.name);
            this.documentVersion(model.documentVersion);
            this.instanceId(model.instanceId);
            this.executionDate(model.executionDate);
            this.status(model.status);
            this.detailedStatus(model.detailedStatus);
            this.executionSummary(model.executionSummary);
            this.errorCode(model.errorCode);
            this.outputUrl(model.outputUrl);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Instant getExecutionDate() {
            return this.executionDate;
        }

        @Override
        public final Builder executionDate(Instant executionDate) {
            this.executionDate = executionDate;
            return this;
        }

        public final void setExecutionDate(Instant executionDate) {
            this.executionDate = executionDate;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDetailedStatus() {
            return this.detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        public final String getExecutionSummary() {
            return this.executionSummary;
        }

        @Override
        public final Builder executionSummary(String executionSummary) {
            this.executionSummary = executionSummary;
            return this;
        }

        public final void setExecutionSummary(String executionSummary) {
            this.executionSummary = executionSummary;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final InstanceAssociationOutputUrl.Builder getOutputUrl() {
            return this.outputUrl != null ? this.outputUrl.toBuilder() : null;
        }

        @Override
        public final Builder outputUrl(InstanceAssociationOutputUrl outputUrl) {
            this.outputUrl = outputUrl;
            return this;
        }

        public final void setOutputUrl(InstanceAssociationOutputUrl.BuilderImpl outputUrl) {
            this.outputUrl = outputUrl != null ? outputUrl.build() : null;
        }

        public InstanceAssociationStatusInfo build() {
            return new InstanceAssociationStatusInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceAssociationStatusInfo> {
        public Builder associationId(String var1);

        public Builder name(String var1);

        public Builder documentVersion(String var1);

        public Builder instanceId(String var1);

        public Builder executionDate(Instant var1);

        public Builder status(String var1);

        public Builder detailedStatus(String var1);

        public Builder executionSummary(String var1);

        public Builder errorCode(String var1);

        public Builder outputUrl(InstanceAssociationOutputUrl var1);
    }
}

