/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ssm.model.PatchFilterGroup;
import software.amazon.awssdk.services.ssm.model.PatchIdListCopier;
import software.amazon.awssdk.services.ssm.model.PatchRuleGroup;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdatePatchBaselineRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdatePatchBaselineRequest> {
    private final String baselineId;
    private final String name;
    private final PatchFilterGroup globalFilters;
    private final PatchRuleGroup approvalRules;
    private final List<String> approvedPatches;
    private final List<String> rejectedPatches;
    private final String description;

    private UpdatePatchBaselineRequest(BuilderImpl builder) {
        this.baselineId = builder.baselineId;
        this.name = builder.name;
        this.globalFilters = builder.globalFilters;
        this.approvalRules = builder.approvalRules;
        this.approvedPatches = builder.approvedPatches;
        this.rejectedPatches = builder.rejectedPatches;
        this.description = builder.description;
    }

    public String baselineId() {
        return this.baselineId;
    }

    public String name() {
        return this.name;
    }

    public PatchFilterGroup globalFilters() {
        return this.globalFilters;
    }

    public PatchRuleGroup approvalRules() {
        return this.approvalRules;
    }

    public List<String> approvedPatches() {
        return this.approvedPatches;
    }

    public List<String> rejectedPatches() {
        return this.rejectedPatches;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.baselineId() == null ? 0 : this.baselineId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.globalFilters() == null ? 0 : this.globalFilters().hashCode());
        hashCode = 31 * hashCode + (this.approvalRules() == null ? 0 : this.approvalRules().hashCode());
        hashCode = 31 * hashCode + (this.approvedPatches() == null ? 0 : this.approvedPatches().hashCode());
        hashCode = 31 * hashCode + (this.rejectedPatches() == null ? 0 : this.rejectedPatches().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePatchBaselineRequest)) {
            return false;
        }
        UpdatePatchBaselineRequest other = (UpdatePatchBaselineRequest)((Object)obj);
        if (other.baselineId() == null ^ this.baselineId() == null) {
            return false;
        }
        if (other.baselineId() != null && !other.baselineId().equals(this.baselineId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.globalFilters() == null ^ this.globalFilters() == null) {
            return false;
        }
        if (other.globalFilters() != null && !other.globalFilters().equals(this.globalFilters())) {
            return false;
        }
        if (other.approvalRules() == null ^ this.approvalRules() == null) {
            return false;
        }
        if (other.approvalRules() != null && !other.approvalRules().equals(this.approvalRules())) {
            return false;
        }
        if (other.approvedPatches() == null ^ this.approvedPatches() == null) {
            return false;
        }
        if (other.approvedPatches() != null && !other.approvedPatches().equals(this.approvedPatches())) {
            return false;
        }
        if (other.rejectedPatches() == null ^ this.rejectedPatches() == null) {
            return false;
        }
        if (other.rejectedPatches() != null && !other.rejectedPatches().equals(this.rejectedPatches())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        return other.description() == null || other.description().equals(this.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.baselineId() != null) {
            sb.append("BaselineId: ").append(this.baselineId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.globalFilters() != null) {
            sb.append("GlobalFilters: ").append(this.globalFilters()).append(",");
        }
        if (this.approvalRules() != null) {
            sb.append("ApprovalRules: ").append(this.approvalRules()).append(",");
        }
        if (this.approvedPatches() != null) {
            sb.append("ApprovedPatches: ").append(this.approvedPatches()).append(",");
        }
        if (this.rejectedPatches() != null) {
            sb.append("RejectedPatches: ").append(this.rejectedPatches()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaselineId": {
                return Optional.of(clazz.cast(this.baselineId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "GlobalFilters": {
                return Optional.of(clazz.cast(this.globalFilters()));
            }
            case "ApprovalRules": {
                return Optional.of(clazz.cast(this.approvalRules()));
            }
            case "ApprovedPatches": {
                return Optional.of(clazz.cast(this.approvedPatches()));
            }
            case "RejectedPatches": {
                return Optional.of(clazz.cast(this.rejectedPatches()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String baselineId;
        private String name;
        private PatchFilterGroup globalFilters;
        private PatchRuleGroup approvalRules;
        private List<String> approvedPatches;
        private List<String> rejectedPatches;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePatchBaselineRequest model) {
            this.baselineId(model.baselineId);
            this.name(model.name);
            this.globalFilters(model.globalFilters);
            this.approvalRules(model.approvalRules);
            this.approvedPatches(model.approvedPatches);
            this.rejectedPatches(model.rejectedPatches);
            this.description(model.description);
        }

        public final String getBaselineId() {
            return this.baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final PatchFilterGroup.Builder getGlobalFilters() {
            return this.globalFilters != null ? this.globalFilters.toBuilder() : null;
        }

        @Override
        public final Builder globalFilters(PatchFilterGroup globalFilters) {
            this.globalFilters = globalFilters;
            return this;
        }

        public final void setGlobalFilters(PatchFilterGroup.BuilderImpl globalFilters) {
            this.globalFilters = globalFilters != null ? globalFilters.build() : null;
        }

        public final PatchRuleGroup.Builder getApprovalRules() {
            return this.approvalRules != null ? this.approvalRules.toBuilder() : null;
        }

        @Override
        public final Builder approvalRules(PatchRuleGroup approvalRules) {
            this.approvalRules = approvalRules;
            return this;
        }

        public final void setApprovalRules(PatchRuleGroup.BuilderImpl approvalRules) {
            this.approvalRules = approvalRules != null ? approvalRules.build() : null;
        }

        public final Collection<String> getApprovedPatches() {
            return this.approvedPatches;
        }

        @Override
        public final Builder approvedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvedPatches(String ... approvedPatches) {
            this.approvedPatches(Arrays.asList(approvedPatches));
            return this;
        }

        public final void setApprovedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
        }

        public final Collection<String> getRejectedPatches() {
            return this.rejectedPatches;
        }

        @Override
        public final Builder rejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectedPatches(String ... rejectedPatches) {
            this.rejectedPatches(Arrays.asList(rejectedPatches));
            return this;
        }

        public final void setRejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public UpdatePatchBaselineRequest build() {
            return new UpdatePatchBaselineRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdatePatchBaselineRequest> {
        public Builder baselineId(String var1);

        public Builder name(String var1);

        public Builder globalFilters(PatchFilterGroup var1);

        public Builder approvalRules(PatchRuleGroup var1);

        public Builder approvedPatches(Collection<String> var1);

        public Builder approvedPatches(String ... var1);

        public Builder rejectedPatches(Collection<String> var1);

        public Builder rejectedPatches(String ... var1);

        public Builder description(String var1);
    }
}

