/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.AssociationOverviewMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AssociationOverview implements StructuredPojo, ToCopyableBuilder<AssociationOverview.Builder, AssociationOverview> {
    private final String status;

    private final String detailedStatus;

    private final Map<String, Integer> associationStatusAggregatedCount;

    private AssociationOverview(BuilderImpl builder) {
        this.status = builder.status;
        this.detailedStatus = builder.detailedStatus;
        this.associationStatusAggregatedCount = builder.associationStatusAggregatedCount;
    }

    /**
     * <p>
     * The status of the association. Status can be: Pending, Success, or Failed.
     * </p>
     * 
     * @return The status of the association. Status can be: Pending, Success, or Failed.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * A detailed status of the association.
     * </p>
     * 
     * @return A detailed status of the association.
     */
    public String detailedStatus() {
        return detailedStatus;
    }

    /**
     * <p>
     * Returns the number of targets for the association status. For example, if you created an association with two
     * instances, and one of them was successful, this would return the count of instances by status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Returns the number of targets for the association status. For example, if you created an association with
     *         two instances, and one of them was successful, this would return the count of instances by status.
     */
    public Map<String, Integer> associationStatusAggregatedCount() {
        return associationStatusAggregatedCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(detailedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(associationStatusAggregatedCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationOverview)) {
            return false;
        }
        AssociationOverview other = (AssociationOverview) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(detailedStatus(), other.detailedStatus())
                && Objects.equals(associationStatusAggregatedCount(), other.associationStatusAggregatedCount());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (detailedStatus() != null) {
            sb.append("DetailedStatus: ").append(detailedStatus()).append(",");
        }
        if (associationStatusAggregatedCount() != null) {
            sb.append("AssociationStatusAggregatedCount: ").append(associationStatusAggregatedCount()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.of(clazz.cast(status()));
        case "DetailedStatus":
            return Optional.of(clazz.cast(detailedStatus()));
        case "AssociationStatusAggregatedCount":
            return Optional.of(clazz.cast(associationStatusAggregatedCount()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssociationOverviewMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AssociationOverview> {
        /**
         * <p>
         * The status of the association. Status can be: Pending, Success, or Failed.
         * </p>
         * 
         * @param status
         *        The status of the association. Status can be: Pending, Success, or Failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A detailed status of the association.
         * </p>
         * 
         * @param detailedStatus
         *        A detailed status of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailedStatus(String detailedStatus);

        /**
         * <p>
         * Returns the number of targets for the association status. For example, if you created an association with two
         * instances, and one of them was successful, this would return the count of instances by status.
         * </p>
         * 
         * @param associationStatusAggregatedCount
         *        Returns the number of targets for the association status. For example, if you created an association
         *        with two instances, and one of them was successful, this would return the count of instances by
         *        status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationStatusAggregatedCount(Map<String, Integer> associationStatusAggregatedCount);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String detailedStatus;

        private Map<String, Integer> associationStatusAggregatedCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationOverview model) {
            status(model.status);
            detailedStatus(model.detailedStatus);
            associationStatusAggregatedCount(model.associationStatusAggregatedCount);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDetailedStatus() {
            return detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        public final Map<String, Integer> getAssociationStatusAggregatedCount() {
            return associationStatusAggregatedCount;
        }

        @Override
        public final Builder associationStatusAggregatedCount(Map<String, Integer> associationStatusAggregatedCount) {
            this.associationStatusAggregatedCount = AssociationStatusAggregatedCountCopier.copy(associationStatusAggregatedCount);
            return this;
        }

        public final void setAssociationStatusAggregatedCount(Map<String, Integer> associationStatusAggregatedCount) {
            this.associationStatusAggregatedCount = AssociationStatusAggregatedCountCopier.copy(associationStatusAggregatedCount);
        }

        @Override
        public AssociationOverview build() {
            return new AssociationOverview(this);
        }
    }
}
