/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateResourceDataSyncRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateResourceDataSyncRequest.Builder, CreateResourceDataSyncRequest> {
    private final String syncName;

    private final ResourceDataSyncS3Destination s3Destination;

    private CreateResourceDataSyncRequest(BuilderImpl builder) {
        this.syncName = builder.syncName;
        this.s3Destination = builder.s3Destination;
    }

    /**
     * <p>
     * A name for the configuration.
     * </p>
     * 
     * @return A name for the configuration.
     */
    public String syncName() {
        return syncName;
    }

    /**
     * <p>
     * Amazon S3 configuration details for the sync.
     * </p>
     * 
     * @return Amazon S3 configuration details for the sync.
     */
    public ResourceDataSyncS3Destination s3Destination() {
        return s3Destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(syncName());
        hashCode = 31 * hashCode + Objects.hashCode(s3Destination());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceDataSyncRequest)) {
            return false;
        }
        CreateResourceDataSyncRequest other = (CreateResourceDataSyncRequest) obj;
        return Objects.equals(syncName(), other.syncName()) && Objects.equals(s3Destination(), other.s3Destination());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (syncName() != null) {
            sb.append("SyncName: ").append(syncName()).append(",");
        }
        if (s3Destination() != null) {
            sb.append("S3Destination: ").append(s3Destination()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SyncName":
            return Optional.of(clazz.cast(syncName()));
        case "S3Destination":
            return Optional.of(clazz.cast(s3Destination()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateResourceDataSyncRequest> {
        /**
         * <p>
         * A name for the configuration.
         * </p>
         * 
         * @param syncName
         *        A name for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncName(String syncName);

        /**
         * <p>
         * Amazon S3 configuration details for the sync.
         * </p>
         * 
         * @param s3Destination
         *        Amazon S3 configuration details for the sync.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Destination(ResourceDataSyncS3Destination s3Destination);

        /**
         * <p>
         * Amazon S3 configuration details for the sync.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceDataSyncS3Destination.Builder} avoiding
         * the need to create one manually via {@link ResourceDataSyncS3Destination#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceDataSyncS3Destination.Builder#build()} is called
         * immediately and its result is passed to {@link #s3Destination(ResourceDataSyncS3Destination)}.
         * 
         * @param s3Destination
         *        a consumer that will call methods on {@link ResourceDataSyncS3Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Destination(ResourceDataSyncS3Destination)
         */
        default Builder s3Destination(Consumer<ResourceDataSyncS3Destination.Builder> s3Destination) {
            return s3Destination(ResourceDataSyncS3Destination.builder().apply(s3Destination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String syncName;

        private ResourceDataSyncS3Destination s3Destination;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceDataSyncRequest model) {
            syncName(model.syncName);
            s3Destination(model.s3Destination);
        }

        public final String getSyncName() {
            return syncName;
        }

        @Override
        public final Builder syncName(String syncName) {
            this.syncName = syncName;
            return this;
        }

        public final void setSyncName(String syncName) {
            this.syncName = syncName;
        }

        public final ResourceDataSyncS3Destination.Builder getS3Destination() {
            return s3Destination != null ? s3Destination.toBuilder() : null;
        }

        @Override
        public final Builder s3Destination(ResourceDataSyncS3Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        public final void setS3Destination(ResourceDataSyncS3Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        public CreateResourceDataSyncRequest build() {
            return new CreateResourceDataSyncRequest(this);
        }
    }
}
