/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteActivationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteActivationRequest.Builder, DeleteActivationRequest> {
    private final String activationId;

    private DeleteActivationRequest(BuilderImpl builder) {
        this.activationId = builder.activationId;
    }

    /**
     * <p>
     * The ID of the activation that you want to delete.
     * </p>
     * 
     * @return The ID of the activation that you want to delete.
     */
    public String activationId() {
        return activationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteActivationRequest)) {
            return false;
        }
        DeleteActivationRequest other = (DeleteActivationRequest) obj;
        return Objects.equals(activationId(), other.activationId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (activationId() != null) {
            sb.append("ActivationId: ").append(activationId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivationId":
            return Optional.of(clazz.cast(activationId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteActivationRequest> {
        /**
         * <p>
         * The ID of the activation that you want to delete.
         * </p>
         * 
         * @param activationId
         *        The ID of the activation that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationId(String activationId);
    }

    static final class BuilderImpl implements Builder {
        private String activationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteActivationRequest model) {
            activationId(model.activationId);
        }

        public final String getActivationId() {
            return activationId;
        }

        @Override
        public final Builder activationId(String activationId) {
            this.activationId = activationId;
            return this;
        }

        public final void setActivationId(String activationId) {
            this.activationId = activationId;
        }

        @Override
        public DeleteActivationRequest build() {
            return new DeleteActivationRequest(this);
        }
    }
}
