/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeEffectiveInstanceAssociationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeEffectiveInstanceAssociationsResponse.Builder, DescribeEffectiveInstanceAssociationsResponse> {
    private final List<InstanceAssociation> associations;

    private final String nextToken;

    private DescribeEffectiveInstanceAssociationsResponse(BuilderImpl builder) {
        this.associations = builder.associations;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The associations for the requested instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The associations for the requested instance.
     */
    public List<InstanceAssociation> associations() {
        return associations;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associations());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEffectiveInstanceAssociationsResponse)) {
            return false;
        }
        DescribeEffectiveInstanceAssociationsResponse other = (DescribeEffectiveInstanceAssociationsResponse) obj;
        return Objects.equals(associations(), other.associations()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (associations() != null) {
            sb.append("Associations: ").append(associations()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Associations":
            return Optional.of(clazz.cast(associations()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeEffectiveInstanceAssociationsResponse> {
        /**
         * <p>
         * The associations for the requested instance.
         * </p>
         * 
         * @param associations
         *        The associations for the requested instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Collection<InstanceAssociation> associations);

        /**
         * <p>
         * The associations for the requested instance.
         * </p>
         * 
         * @param associations
         *        The associations for the requested instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(InstanceAssociation... associations);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<InstanceAssociation> associations;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEffectiveInstanceAssociationsResponse model) {
            associations(model.associations);
            nextToken(model.nextToken);
        }

        public final Collection<InstanceAssociation.Builder> getAssociations() {
            return associations != null ? associations.stream().map(InstanceAssociation::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder associations(Collection<InstanceAssociation> associations) {
            this.associations = InstanceAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(InstanceAssociation... associations) {
            associations(Arrays.asList(associations));
            return this;
        }

        public final void setAssociations(Collection<InstanceAssociation.BuilderImpl> associations) {
            this.associations = InstanceAssociationListCopier.copyFromBuilder(associations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEffectiveInstanceAssociationsResponse build() {
            return new DescribeEffectiveInstanceAssociationsResponse(this);
        }
    }
}
