/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeParametersResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeParametersResponse.Builder, DescribeParametersResponse> {
    private final List<ParameterMetadata> parameters;

    private final String nextToken;

    private DescribeParametersResponse(BuilderImpl builder) {
        this.parameters = builder.parameters;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Parameters returned by the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Parameters returned by the request.
     */
    public List<ParameterMetadata> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeParametersResponse)) {
            return false;
        }
        DescribeParametersResponse other = (DescribeParametersResponse) obj;
        return Objects.equals(parameters(), other.parameters()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Parameters":
            return Optional.of(clazz.cast(parameters()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeParametersResponse> {
        /**
         * <p>
         * Parameters returned by the request.
         * </p>
         * 
         * @param parameters
         *        Parameters returned by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<ParameterMetadata> parameters);

        /**
         * <p>
         * Parameters returned by the request.
         * </p>
         * 
         * @param parameters
         *        Parameters returned by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(ParameterMetadata... parameters);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<ParameterMetadata> parameters;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeParametersResponse model) {
            parameters(model.parameters);
            nextToken(model.nextToken);
        }

        public final Collection<ParameterMetadata.Builder> getParameters() {
            return parameters != null ? parameters.stream().map(ParameterMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<ParameterMetadata> parameters) {
            this.parameters = ParameterMetadataListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ParameterMetadata... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<ParameterMetadata.BuilderImpl> parameters) {
            this.parameters = ParameterMetadataListCopier.copyFromBuilder(parameters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeParametersResponse build() {
            return new DescribeParametersResponse(this);
        }
    }
}
