/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribePatchBaselinesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribePatchBaselinesResponse.Builder, DescribePatchBaselinesResponse> {
    private final List<PatchBaselineIdentity> baselineIdentities;

    private final String nextToken;

    private DescribePatchBaselinesResponse(BuilderImpl builder) {
        this.baselineIdentities = builder.baselineIdentities;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of PatchBaselineIdentity elements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of PatchBaselineIdentity elements.
     */
    public List<PatchBaselineIdentity> baselineIdentities() {
        return baselineIdentities;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baselineIdentities());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePatchBaselinesResponse)) {
            return false;
        }
        DescribePatchBaselinesResponse other = (DescribePatchBaselinesResponse) obj;
        return Objects.equals(baselineIdentities(), other.baselineIdentities()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (baselineIdentities() != null) {
            sb.append("BaselineIdentities: ").append(baselineIdentities()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaselineIdentities":
            return Optional.of(clazz.cast(baselineIdentities()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribePatchBaselinesResponse> {
        /**
         * <p>
         * An array of PatchBaselineIdentity elements.
         * </p>
         * 
         * @param baselineIdentities
         *        An array of PatchBaselineIdentity elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineIdentities(Collection<PatchBaselineIdentity> baselineIdentities);

        /**
         * <p>
         * An array of PatchBaselineIdentity elements.
         * </p>
         * 
         * @param baselineIdentities
         *        An array of PatchBaselineIdentity elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineIdentities(PatchBaselineIdentity... baselineIdentities);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<PatchBaselineIdentity> baselineIdentities;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePatchBaselinesResponse model) {
            baselineIdentities(model.baselineIdentities);
            nextToken(model.nextToken);
        }

        public final Collection<PatchBaselineIdentity.Builder> getBaselineIdentities() {
            return baselineIdentities != null ? baselineIdentities.stream().map(PatchBaselineIdentity::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder baselineIdentities(Collection<PatchBaselineIdentity> baselineIdentities) {
            this.baselineIdentities = PatchBaselineIdentityListCopier.copy(baselineIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baselineIdentities(PatchBaselineIdentity... baselineIdentities) {
            baselineIdentities(Arrays.asList(baselineIdentities));
            return this;
        }

        public final void setBaselineIdentities(Collection<PatchBaselineIdentity.BuilderImpl> baselineIdentities) {
            this.baselineIdentities = PatchBaselineIdentityListCopier.copyFromBuilder(baselineIdentities);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribePatchBaselinesResponse build() {
            return new DescribePatchBaselinesResponse(this);
        }
    }
}
