/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetMaintenanceWindowExecutionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetMaintenanceWindowExecutionRequest.Builder, GetMaintenanceWindowExecutionRequest> {
    private final String windowExecutionId;

    private GetMaintenanceWindowExecutionRequest(BuilderImpl builder) {
        this.windowExecutionId = builder.windowExecutionId;
    }

    /**
     * <p>
     * The ID of the Maintenance Window execution that includes the task.
     * </p>
     * 
     * @return The ID of the Maintenance Window execution that includes the task.
     */
    public String windowExecutionId() {
        return windowExecutionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowExecutionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMaintenanceWindowExecutionRequest)) {
            return false;
        }
        GetMaintenanceWindowExecutionRequest other = (GetMaintenanceWindowExecutionRequest) obj;
        return Objects.equals(windowExecutionId(), other.windowExecutionId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (windowExecutionId() != null) {
            sb.append("WindowExecutionId: ").append(windowExecutionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowExecutionId":
            return Optional.of(clazz.cast(windowExecutionId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetMaintenanceWindowExecutionRequest> {
        /**
         * <p>
         * The ID of the Maintenance Window execution that includes the task.
         * </p>
         * 
         * @param windowExecutionId
         *        The ID of the Maintenance Window execution that includes the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionId(String windowExecutionId);
    }

    static final class BuilderImpl implements Builder {
        private String windowExecutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMaintenanceWindowExecutionRequest model) {
            windowExecutionId(model.windowExecutionId);
        }

        public final String getWindowExecutionId() {
            return windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        @Override
        public GetMaintenanceWindowExecutionRequest build() {
            return new GetMaintenanceWindowExecutionRequest(this);
        }
    }
}
