/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetMaintenanceWindowExecutionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetMaintenanceWindowExecutionResponse.Builder, GetMaintenanceWindowExecutionResponse> {
    private final String windowExecutionId;

    private final List<String> taskIds;

    private final String status;

    private final String statusDetails;

    private final Instant startTime;

    private final Instant endTime;

    private GetMaintenanceWindowExecutionResponse(BuilderImpl builder) {
        this.windowExecutionId = builder.windowExecutionId;
        this.taskIds = builder.taskIds;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The ID of the Maintenance Window execution.
     * </p>
     * 
     * @return The ID of the Maintenance Window execution.
     */
    public String windowExecutionId() {
        return windowExecutionId;
    }

    /**
     * <p>
     * The ID of the task executions from the Maintenance Window execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The ID of the task executions from the Maintenance Window execution.
     */
    public List<String> taskIds() {
        return taskIds;
    }

    /**
     * <p>
     * The status of the Maintenance Window execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MaintenanceWindowExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusString}.
     * </p>
     * 
     * @return The status of the Maintenance Window execution.
     * @see MaintenanceWindowExecutionStatus
     */
    public MaintenanceWindowExecutionStatus status() {
        return MaintenanceWindowExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Maintenance Window execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MaintenanceWindowExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusString}.
     * </p>
     * 
     * @return The status of the Maintenance Window execution.
     * @see MaintenanceWindowExecutionStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * <p>
     * The details explaining the Status. Only available for certain status values.
     * </p>
     * 
     * @return The details explaining the Status. Only available for certain status values.
     */
    public String statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * The time the Maintenance Window started executing.
     * </p>
     * 
     * @return The time the Maintenance Window started executing.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time the Maintenance Window finished executing.
     * </p>
     * 
     * @return The time the Maintenance Window finished executing.
     */
    public Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(taskIds());
        hashCode = 31 * hashCode + Objects.hashCode(statusString());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMaintenanceWindowExecutionResponse)) {
            return false;
        }
        GetMaintenanceWindowExecutionResponse other = (GetMaintenanceWindowExecutionResponse) obj;
        return Objects.equals(windowExecutionId(), other.windowExecutionId()) && Objects.equals(taskIds(), other.taskIds())
                && Objects.equals(statusString(), other.statusString()) && Objects.equals(statusDetails(), other.statusDetails())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (windowExecutionId() != null) {
            sb.append("WindowExecutionId: ").append(windowExecutionId()).append(",");
        }
        if (taskIds() != null) {
            sb.append("TaskIds: ").append(taskIds()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (statusDetails() != null) {
            sb.append("StatusDetails: ").append(statusDetails()).append(",");
        }
        if (startTime() != null) {
            sb.append("StartTime: ").append(startTime()).append(",");
        }
        if (endTime() != null) {
            sb.append("EndTime: ").append(endTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowExecutionId":
            return Optional.of(clazz.cast(windowExecutionId()));
        case "TaskIds":
            return Optional.of(clazz.cast(taskIds()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        case "StatusDetails":
            return Optional.of(clazz.cast(statusDetails()));
        case "StartTime":
            return Optional.of(clazz.cast(startTime()));
        case "EndTime":
            return Optional.of(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetMaintenanceWindowExecutionResponse> {
        /**
         * <p>
         * The ID of the Maintenance Window execution.
         * </p>
         * 
         * @param windowExecutionId
         *        The ID of the Maintenance Window execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionId(String windowExecutionId);

        /**
         * <p>
         * The ID of the task executions from the Maintenance Window execution.
         * </p>
         * 
         * @param taskIds
         *        The ID of the task executions from the Maintenance Window execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskIds(Collection<String> taskIds);

        /**
         * <p>
         * The ID of the task executions from the Maintenance Window execution.
         * </p>
         * 
         * @param taskIds
         *        The ID of the task executions from the Maintenance Window execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskIds(String... taskIds);

        /**
         * <p>
         * The status of the Maintenance Window execution.
         * </p>
         * 
         * @param status
         *        The status of the Maintenance Window execution.
         * @see MaintenanceWindowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Maintenance Window execution.
         * </p>
         * 
         * @param status
         *        The status of the Maintenance Window execution.
         * @see MaintenanceWindowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowExecutionStatus
         */
        Builder status(MaintenanceWindowExecutionStatus status);

        /**
         * <p>
         * The details explaining the Status. Only available for certain status values.
         * </p>
         * 
         * @param statusDetails
         *        The details explaining the Status. Only available for certain status values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(String statusDetails);

        /**
         * <p>
         * The time the Maintenance Window started executing.
         * </p>
         * 
         * @param startTime
         *        The time the Maintenance Window started executing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time the Maintenance Window finished executing.
         * </p>
         * 
         * @param endTime
         *        The time the Maintenance Window finished executing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl implements Builder {
        private String windowExecutionId;

        private List<String> taskIds;

        private String status;

        private String statusDetails;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMaintenanceWindowExecutionResponse model) {
            windowExecutionId(model.windowExecutionId);
            taskIds(model.taskIds);
            status(model.status);
            statusDetails(model.statusDetails);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getWindowExecutionId() {
            return windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        public final Collection<String> getTaskIds() {
            return taskIds;
        }

        @Override
        public final Builder taskIds(Collection<String> taskIds) {
            this.taskIds = MaintenanceWindowExecutionTaskIdListCopier.copy(taskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskIds(String... taskIds) {
            taskIds(Arrays.asList(taskIds));
            return this;
        }

        public final void setTaskIds(Collection<String> taskIds) {
            this.taskIds = MaintenanceWindowExecutionTaskIdListCopier.copy(taskIds);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaintenanceWindowExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public GetMaintenanceWindowExecutionResponse build() {
            return new GetMaintenanceWindowExecutionResponse(this);
        }
    }
}
