/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetMaintenanceWindowTaskResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetMaintenanceWindowTaskResponse.Builder, GetMaintenanceWindowTaskResponse> {
    private final String windowId;

    private final String windowTaskId;

    private final List<Target> targets;

    private final String taskArn;

    private final String serviceRoleArn;

    private final String taskType;

    private final Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters;

    private final MaintenanceWindowTaskInvocationParameters taskInvocationParameters;

    private final Integer priority;

    private final String maxConcurrency;

    private final String maxErrors;

    private final LoggingInfo loggingInfo;

    private final String name;

    private final String description;

    private GetMaintenanceWindowTaskResponse(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.windowTaskId = builder.windowTaskId;
        this.targets = builder.targets;
        this.taskArn = builder.taskArn;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.taskType = builder.taskType;
        this.taskParameters = builder.taskParameters;
        this.taskInvocationParameters = builder.taskInvocationParameters;
        this.priority = builder.priority;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.loggingInfo = builder.loggingInfo;
        this.name = builder.name;
        this.description = builder.description;
    }

    /**
     * <p>
     * The retrieved Maintenance Window ID.
     * </p>
     * 
     * @return The retrieved Maintenance Window ID.
     */
    public String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The retrieved Maintenance Window task ID.
     * </p>
     * 
     * @return The retrieved Maintenance Window task ID.
     */
    public String windowTaskId() {
        return windowTaskId;
    }

    /**
     * <p>
     * The targets where the task should execute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The targets where the task should execute.
     */
    public List<Target> targets() {
        return targets;
    }

    /**
     * <p>
     * The resource that the task used during execution. For RUN_COMMAND and AUTOMATION task types, the TaskArn is the
     * Systems Manager Document name/ARN. For LAMBDA tasks, the value is the function name/ARN. For STEP_FUNCTION tasks,
     * the value is the state machine ARN.
     * </p>
     * 
     * @return The resource that the task used during execution. For RUN_COMMAND and AUTOMATION task types, the TaskArn
     *         is the Systems Manager Document name/ARN. For LAMBDA tasks, the value is the function name/ARN. For
     *         STEP_FUNCTION tasks, the value is the state machine ARN.
     */
    public String taskArn() {
        return taskArn;
    }

    /**
     * <p>
     * The IAM service role to assume during task execution.
     * </p>
     * 
     * @return The IAM service role to assume during task execution.
     */
    public String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * <p>
     * The type of task to execute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskType} will
     * return {@link MaintenanceWindowTaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #taskTypeString}.
     * </p>
     * 
     * @return The type of task to execute.
     * @see MaintenanceWindowTaskType
     */
    public MaintenanceWindowTaskType taskType() {
        return MaintenanceWindowTaskType.fromValue(taskType);
    }

    /**
     * <p>
     * The type of task to execute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskType} will
     * return {@link MaintenanceWindowTaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #taskTypeString}.
     * </p>
     * 
     * @return The type of task to execute.
     * @see MaintenanceWindowTaskType
     */
    public String taskTypeString() {
        return taskType;
    }

    /**
     * <p>
     * The parameters to pass to the task when it executes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The parameters to pass to the task when it executes.
     */
    public Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters() {
        return taskParameters;
    }

    /**
     * <p>
     * The parameters to pass to the task when it executes.
     * </p>
     * 
     * @return The parameters to pass to the task when it executes.
     */
    public MaintenanceWindowTaskInvocationParameters taskInvocationParameters() {
        return taskInvocationParameters;
    }

    /**
     * <p>
     * The priority of the task when it executes. The lower the number, the higher the priority. Tasks that have the
     * same priority are scheduled in parallel.
     * </p>
     * 
     * @return The priority of the task when it executes. The lower the number, the higher the priority. Tasks that have
     *         the same priority are scheduled in parallel.
     */
    public Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The maximum number of targets allowed to run this task in parallel.
     * </p>
     * 
     * @return The maximum number of targets allowed to run this task in parallel.
     */
    public String maxConcurrency() {
        return maxConcurrency;
    }

    /**
     * <p>
     * The maximum number of errors allowed before the task stops being scheduled.
     * </p>
     * 
     * @return The maximum number of errors allowed before the task stops being scheduled.
     */
    public String maxErrors() {
        return maxErrors;
    }

    /**
     * <p>
     * The location in Amazon S3 where the task results are logged.
     * </p>
     * 
     * @return The location in Amazon S3 where the task results are logged.
     */
    public LoggingInfo loggingInfo() {
        return loggingInfo;
    }

    /**
     * <p>
     * The retrieved task name.
     * </p>
     * 
     * @return The retrieved task name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The retrieved task description.
     * </p>
     * 
     * @return The retrieved task description.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowId());
        hashCode = 31 * hashCode + Objects.hashCode(windowTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(targets());
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(taskTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(taskParameters());
        hashCode = 31 * hashCode + Objects.hashCode(taskInvocationParameters());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(loggingInfo());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMaintenanceWindowTaskResponse)) {
            return false;
        }
        GetMaintenanceWindowTaskResponse other = (GetMaintenanceWindowTaskResponse) obj;
        return Objects.equals(windowId(), other.windowId()) && Objects.equals(windowTaskId(), other.windowTaskId())
                && Objects.equals(targets(), other.targets()) && Objects.equals(taskArn(), other.taskArn())
                && Objects.equals(serviceRoleArn(), other.serviceRoleArn())
                && Objects.equals(taskTypeString(), other.taskTypeString())
                && Objects.equals(taskParameters(), other.taskParameters())
                && Objects.equals(taskInvocationParameters(), other.taskInvocationParameters())
                && Objects.equals(priority(), other.priority()) && Objects.equals(maxConcurrency(), other.maxConcurrency())
                && Objects.equals(maxErrors(), other.maxErrors()) && Objects.equals(loggingInfo(), other.loggingInfo())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (windowId() != null) {
            sb.append("WindowId: ").append(windowId()).append(",");
        }
        if (windowTaskId() != null) {
            sb.append("WindowTaskId: ").append(windowTaskId()).append(",");
        }
        if (targets() != null) {
            sb.append("Targets: ").append(targets()).append(",");
        }
        if (taskArn() != null) {
            sb.append("TaskArn: ").append(taskArn()).append(",");
        }
        if (serviceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(serviceRoleArn()).append(",");
        }
        if (taskTypeString() != null) {
            sb.append("TaskType: ").append(taskTypeString()).append(",");
        }
        if (taskParameters() != null) {
            sb.append("TaskParameters: ").append(taskParameters()).append(",");
        }
        if (taskInvocationParameters() != null) {
            sb.append("TaskInvocationParameters: ").append(taskInvocationParameters()).append(",");
        }
        if (priority() != null) {
            sb.append("Priority: ").append(priority()).append(",");
        }
        if (maxConcurrency() != null) {
            sb.append("MaxConcurrency: ").append(maxConcurrency()).append(",");
        }
        if (maxErrors() != null) {
            sb.append("MaxErrors: ").append(maxErrors()).append(",");
        }
        if (loggingInfo() != null) {
            sb.append("LoggingInfo: ").append(loggingInfo()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.of(clazz.cast(windowId()));
        case "WindowTaskId":
            return Optional.of(clazz.cast(windowTaskId()));
        case "Targets":
            return Optional.of(clazz.cast(targets()));
        case "TaskArn":
            return Optional.of(clazz.cast(taskArn()));
        case "ServiceRoleArn":
            return Optional.of(clazz.cast(serviceRoleArn()));
        case "TaskType":
            return Optional.of(clazz.cast(taskTypeString()));
        case "TaskParameters":
            return Optional.of(clazz.cast(taskParameters()));
        case "TaskInvocationParameters":
            return Optional.of(clazz.cast(taskInvocationParameters()));
        case "Priority":
            return Optional.of(clazz.cast(priority()));
        case "MaxConcurrency":
            return Optional.of(clazz.cast(maxConcurrency()));
        case "MaxErrors":
            return Optional.of(clazz.cast(maxErrors()));
        case "LoggingInfo":
            return Optional.of(clazz.cast(loggingInfo()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetMaintenanceWindowTaskResponse> {
        /**
         * <p>
         * The retrieved Maintenance Window ID.
         * </p>
         * 
         * @param windowId
         *        The retrieved Maintenance Window ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The retrieved Maintenance Window task ID.
         * </p>
         * 
         * @param windowTaskId
         *        The retrieved Maintenance Window task ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowTaskId(String windowTaskId);

        /**
         * <p>
         * The targets where the task should execute.
         * </p>
         * 
         * @param targets
         *        The targets where the task should execute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * The targets where the task should execute.
         * </p>
         * 
         * @param targets
         *        The targets where the task should execute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);

        /**
         * <p>
         * The resource that the task used during execution. For RUN_COMMAND and AUTOMATION task types, the TaskArn is
         * the Systems Manager Document name/ARN. For LAMBDA tasks, the value is the function name/ARN. For
         * STEP_FUNCTION tasks, the value is the state machine ARN.
         * </p>
         * 
         * @param taskArn
         *        The resource that the task used during execution. For RUN_COMMAND and AUTOMATION task types, the
         *        TaskArn is the Systems Manager Document name/ARN. For LAMBDA tasks, the value is the function
         *        name/ARN. For STEP_FUNCTION tasks, the value is the state machine ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * <p>
         * The IAM service role to assume during task execution.
         * </p>
         * 
         * @param serviceRoleArn
         *        The IAM service role to assume during task execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * The type of task to execute.
         * </p>
         * 
         * @param taskType
         *        The type of task to execute.
         * @see MaintenanceWindowTaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowTaskType
         */
        Builder taskType(String taskType);

        /**
         * <p>
         * The type of task to execute.
         * </p>
         * 
         * @param taskType
         *        The type of task to execute.
         * @see MaintenanceWindowTaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowTaskType
         */
        Builder taskType(MaintenanceWindowTaskType taskType);

        /**
         * <p>
         * The parameters to pass to the task when it executes.
         * </p>
         * 
         * @param taskParameters
         *        The parameters to pass to the task when it executes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters);

        /**
         * <p>
         * The parameters to pass to the task when it executes.
         * </p>
         * 
         * @param taskInvocationParameters
         *        The parameters to pass to the task when it executes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskInvocationParameters(MaintenanceWindowTaskInvocationParameters taskInvocationParameters);

        /**
         * <p>
         * The parameters to pass to the task when it executes.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link MaintenanceWindowTaskInvocationParameters.Builder} avoiding the need to create one manually via
         * {@link MaintenanceWindowTaskInvocationParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link MaintenanceWindowTaskInvocationParameters.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #taskInvocationParameters(MaintenanceWindowTaskInvocationParameters)}.
         * 
         * @param taskInvocationParameters
         *        a consumer that will call methods on {@link MaintenanceWindowTaskInvocationParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskInvocationParameters(MaintenanceWindowTaskInvocationParameters)
         */
        default Builder taskInvocationParameters(
                Consumer<MaintenanceWindowTaskInvocationParameters.Builder> taskInvocationParameters) {
            return taskInvocationParameters(MaintenanceWindowTaskInvocationParameters.builder().apply(taskInvocationParameters)
                    .build());
        }

        /**
         * <p>
         * The priority of the task when it executes. The lower the number, the higher the priority. Tasks that have the
         * same priority are scheduled in parallel.
         * </p>
         * 
         * @param priority
         *        The priority of the task when it executes. The lower the number, the higher the priority. Tasks that
         *        have the same priority are scheduled in parallel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The maximum number of targets allowed to run this task in parallel.
         * </p>
         * 
         * @param maxConcurrency
         *        The maximum number of targets allowed to run this task in parallel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrency(String maxConcurrency);

        /**
         * <p>
         * The maximum number of errors allowed before the task stops being scheduled.
         * </p>
         * 
         * @param maxErrors
         *        The maximum number of errors allowed before the task stops being scheduled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxErrors(String maxErrors);

        /**
         * <p>
         * The location in Amazon S3 where the task results are logged.
         * </p>
         * 
         * @param loggingInfo
         *        The location in Amazon S3 where the task results are logged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingInfo(LoggingInfo loggingInfo);

        /**
         * <p>
         * The location in Amazon S3 where the task results are logged.
         * </p>
         * This is a convenience that creates an instance of the {@link LoggingInfo.Builder} avoiding the need to create
         * one manually via {@link LoggingInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoggingInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #loggingInfo(LoggingInfo)}.
         * 
         * @param loggingInfo
         *        a consumer that will call methods on {@link LoggingInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingInfo(LoggingInfo)
         */
        default Builder loggingInfo(Consumer<LoggingInfo.Builder> loggingInfo) {
            return loggingInfo(LoggingInfo.builder().apply(loggingInfo).build());
        }

        /**
         * <p>
         * The retrieved task name.
         * </p>
         * 
         * @param name
         *        The retrieved task name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The retrieved task description.
         * </p>
         * 
         * @param description
         *        The retrieved task description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String windowId;

        private String windowTaskId;

        private List<Target> targets;

        private String taskArn;

        private String serviceRoleArn;

        private String taskType;

        private Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters;

        private MaintenanceWindowTaskInvocationParameters taskInvocationParameters;

        private Integer priority;

        private String maxConcurrency;

        private String maxErrors;

        private LoggingInfo loggingInfo;

        private String name;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMaintenanceWindowTaskResponse model) {
            windowId(model.windowId);
            windowTaskId(model.windowTaskId);
            targets(model.targets);
            taskArn(model.taskArn);
            serviceRoleArn(model.serviceRoleArn);
            taskType(model.taskType);
            taskParameters(model.taskParameters);
            taskInvocationParameters(model.taskInvocationParameters);
            priority(model.priority);
            maxConcurrency(model.maxConcurrency);
            maxErrors(model.maxErrors);
            loggingInfo(model.loggingInfo);
            name(model.name);
            description(model.description);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getWindowTaskId() {
            return windowTaskId;
        }

        @Override
        public final Builder windowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
            return this;
        }

        public final void setWindowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
        }

        public final Collection<Target.Builder> getTargets() {
            return targets != null ? targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final String getTaskArn() {
            return taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final String getTaskType() {
            return taskType;
        }

        @Override
        public final Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @Override
        public final Builder taskType(MaintenanceWindowTaskType taskType) {
            this.taskType(taskType.toString());
            return this;
        }

        public final void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        public final Map<String, MaintenanceWindowTaskParameterValueExpression.Builder> getTaskParameters() {
            return taskParameters != null ? CollectionUtils.mapValues(taskParameters,
                    MaintenanceWindowTaskParameterValueExpression::toBuilder) : null;
        }

        @Override
        public final Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersCopier.copy(taskParameters);
            return this;
        }

        public final void setTaskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression.BuilderImpl> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersCopier.copyFromBuilder(taskParameters);
        }

        public final MaintenanceWindowTaskInvocationParameters.Builder getTaskInvocationParameters() {
            return taskInvocationParameters != null ? taskInvocationParameters.toBuilder() : null;
        }

        @Override
        public final Builder taskInvocationParameters(MaintenanceWindowTaskInvocationParameters taskInvocationParameters) {
            this.taskInvocationParameters = taskInvocationParameters;
            return this;
        }

        public final void setTaskInvocationParameters(
                MaintenanceWindowTaskInvocationParameters.BuilderImpl taskInvocationParameters) {
            this.taskInvocationParameters = taskInvocationParameters != null ? taskInvocationParameters.build() : null;
        }

        public final Integer getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getMaxConcurrency() {
            return maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getMaxErrors() {
            return maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final LoggingInfo.Builder getLoggingInfo() {
            return loggingInfo != null ? loggingInfo.toBuilder() : null;
        }

        @Override
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final void setLoggingInfo(LoggingInfo.BuilderImpl loggingInfo) {
            this.loggingInfo = loggingInfo != null ? loggingInfo.build() : null;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public GetMaintenanceWindowTaskResponse build() {
            return new GetMaintenanceWindowTaskResponse(this);
        }
    }
}
