/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetPatchBaselineForPatchGroupResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetPatchBaselineForPatchGroupResponse.Builder, GetPatchBaselineForPatchGroupResponse> {
    private final String baselineId;

    private final String patchGroup;

    private final String operatingSystem;

    private GetPatchBaselineForPatchGroupResponse(BuilderImpl builder) {
        this.baselineId = builder.baselineId;
        this.patchGroup = builder.patchGroup;
        this.operatingSystem = builder.operatingSystem;
    }

    /**
     * <p>
     * The ID of the patch baseline that should be used for the patch group.
     * </p>
     * 
     * @return The ID of the patch baseline that should be used for the patch group.
     */
    public String baselineId() {
        return baselineId;
    }

    /**
     * <p>
     * The name of the patch group.
     * </p>
     * 
     * @return The name of the patch group.
     */
    public String patchGroup() {
        return patchGroup;
    }

    /**
     * <p>
     * The operating system rule specified for patch groups using the patch baseline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemString}.
     * </p>
     * 
     * @return The operating system rule specified for patch groups using the patch baseline.
     * @see OperatingSystem
     */
    public OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(operatingSystem);
    }

    /**
     * <p>
     * The operating system rule specified for patch groups using the patch baseline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemString}.
     * </p>
     * 
     * @return The operating system rule specified for patch groups using the patch baseline.
     * @see OperatingSystem
     */
    public String operatingSystemString() {
        return operatingSystem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baselineId());
        hashCode = 31 * hashCode + Objects.hashCode(patchGroup());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPatchBaselineForPatchGroupResponse)) {
            return false;
        }
        GetPatchBaselineForPatchGroupResponse other = (GetPatchBaselineForPatchGroupResponse) obj;
        return Objects.equals(baselineId(), other.baselineId()) && Objects.equals(patchGroup(), other.patchGroup())
                && Objects.equals(operatingSystemString(), other.operatingSystemString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (baselineId() != null) {
            sb.append("BaselineId: ").append(baselineId()).append(",");
        }
        if (patchGroup() != null) {
            sb.append("PatchGroup: ").append(patchGroup()).append(",");
        }
        if (operatingSystemString() != null) {
            sb.append("OperatingSystem: ").append(operatingSystemString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaselineId":
            return Optional.of(clazz.cast(baselineId()));
        case "PatchGroup":
            return Optional.of(clazz.cast(patchGroup()));
        case "OperatingSystem":
            return Optional.of(clazz.cast(operatingSystemString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetPatchBaselineForPatchGroupResponse> {
        /**
         * <p>
         * The ID of the patch baseline that should be used for the patch group.
         * </p>
         * 
         * @param baselineId
         *        The ID of the patch baseline that should be used for the patch group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineId(String baselineId);

        /**
         * <p>
         * The name of the patch group.
         * </p>
         * 
         * @param patchGroup
         *        The name of the patch group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchGroup(String patchGroup);

        /**
         * <p>
         * The operating system rule specified for patch groups using the patch baseline.
         * </p>
         * 
         * @param operatingSystem
         *        The operating system rule specified for patch groups using the patch baseline.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(String operatingSystem);

        /**
         * <p>
         * The operating system rule specified for patch groups using the patch baseline.
         * </p>
         * 
         * @param operatingSystem
         *        The operating system rule specified for patch groups using the patch baseline.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(OperatingSystem operatingSystem);
    }

    static final class BuilderImpl implements Builder {
        private String baselineId;

        private String patchGroup;

        private String operatingSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPatchBaselineForPatchGroupResponse model) {
            baselineId(model.baselineId);
            patchGroup(model.patchGroup);
            operatingSystem(model.operatingSystem);
        }

        public final String getBaselineId() {
            return baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        public final String getPatchGroup() {
            return patchGroup;
        }

        @Override
        public final Builder patchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
            return this;
        }

        public final void setPatchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
        }

        public final String getOperatingSystem() {
            return operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public GetPatchBaselineForPatchGroupResponse build() {
            return new GetPatchBaselineForPatchGroupResponse(this);
        }
    }
}
