/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListComplianceSummariesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListComplianceSummariesResponse.Builder, ListComplianceSummariesResponse> {
    private final List<ComplianceSummaryItem> complianceSummaryItems;

    private final String nextToken;

    private ListComplianceSummariesResponse(BuilderImpl builder) {
        this.complianceSummaryItems = builder.complianceSummaryItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of compliant and non-compliant summary counts based on compliance types. For example, this call returns
     * State Manager associations, patches, or custom compliance types according to the filter criteria that you
     * specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of compliant and non-compliant summary counts based on compliance types. For example, this call
     *         returns State Manager associations, patches, or custom compliance types according to the filter criteria
     *         that you specified.
     */
    public List<ComplianceSummaryItem> complianceSummaryItems() {
        return complianceSummaryItems;
    }

    /**
     * <p>
     * The token for the next set of items to return. Use this token to get the next set of results.
     * </p>
     * 
     * @return The token for the next set of items to return. Use this token to get the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(complianceSummaryItems());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComplianceSummariesResponse)) {
            return false;
        }
        ListComplianceSummariesResponse other = (ListComplianceSummariesResponse) obj;
        return Objects.equals(complianceSummaryItems(), other.complianceSummaryItems())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (complianceSummaryItems() != null) {
            sb.append("ComplianceSummaryItems: ").append(complianceSummaryItems()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceSummaryItems":
            return Optional.of(clazz.cast(complianceSummaryItems()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListComplianceSummariesResponse> {
        /**
         * <p>
         * A list of compliant and non-compliant summary counts based on compliance types. For example, this call
         * returns State Manager associations, patches, or custom compliance types according to the filter criteria that
         * you specified.
         * </p>
         * 
         * @param complianceSummaryItems
         *        A list of compliant and non-compliant summary counts based on compliance types. For example, this call
         *        returns State Manager associations, patches, or custom compliance types according to the filter
         *        criteria that you specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceSummaryItems(Collection<ComplianceSummaryItem> complianceSummaryItems);

        /**
         * <p>
         * A list of compliant and non-compliant summary counts based on compliance types. For example, this call
         * returns State Manager associations, patches, or custom compliance types according to the filter criteria that
         * you specified.
         * </p>
         * 
         * @param complianceSummaryItems
         *        A list of compliant and non-compliant summary counts based on compliance types. For example, this call
         *        returns State Manager associations, patches, or custom compliance types according to the filter
         *        criteria that you specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceSummaryItems(ComplianceSummaryItem... complianceSummaryItems);

        /**
         * <p>
         * The token for the next set of items to return. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<ComplianceSummaryItem> complianceSummaryItems;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComplianceSummariesResponse model) {
            complianceSummaryItems(model.complianceSummaryItems);
            nextToken(model.nextToken);
        }

        public final Collection<ComplianceSummaryItem.Builder> getComplianceSummaryItems() {
            return complianceSummaryItems != null ? complianceSummaryItems.stream().map(ComplianceSummaryItem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder complianceSummaryItems(Collection<ComplianceSummaryItem> complianceSummaryItems) {
            this.complianceSummaryItems = ComplianceSummaryItemListCopier.copy(complianceSummaryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceSummaryItems(ComplianceSummaryItem... complianceSummaryItems) {
            complianceSummaryItems(Arrays.asList(complianceSummaryItems));
            return this;
        }

        public final void setComplianceSummaryItems(Collection<ComplianceSummaryItem.BuilderImpl> complianceSummaryItems) {
            this.complianceSummaryItems = ComplianceSummaryItemListCopier.copyFromBuilder(complianceSummaryItems);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListComplianceSummariesResponse build() {
            return new ListComplianceSummariesResponse(this);
        }
    }
}
