/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListInventoryEntriesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListInventoryEntriesResponse.Builder, ListInventoryEntriesResponse> {
    private final String typeName;

    private final String instanceId;

    private final String schemaVersion;

    private final String captureTime;

    private final List<Map<String, String>> entries;

    private final String nextToken;

    private ListInventoryEntriesResponse(BuilderImpl builder) {
        this.typeName = builder.typeName;
        this.instanceId = builder.instanceId;
        this.schemaVersion = builder.schemaVersion;
        this.captureTime = builder.captureTime;
        this.entries = builder.entries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The type of inventory item returned by the request.
     * </p>
     * 
     * @return The type of inventory item returned by the request.
     */
    public String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The instance ID targeted by the request to query inventory information.
     * </p>
     * 
     * @return The instance ID targeted by the request to query inventory information.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The inventory schema version used by the instance(s).
     * </p>
     * 
     * @return The inventory schema version used by the instance(s).
     */
    public String schemaVersion() {
        return schemaVersion;
    }

    /**
     * <p>
     * The time that inventory information was collected for the instance(s).
     * </p>
     * 
     * @return The time that inventory information was collected for the instance(s).
     */
    public String captureTime() {
        return captureTime;
    }

    /**
     * <p>
     * A list of inventory items on the instance(s).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of inventory items on the instance(s).
     */
    public List<Map<String, String>> entries() {
        return entries;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(captureTime());
        hashCode = 31 * hashCode + Objects.hashCode(entries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInventoryEntriesResponse)) {
            return false;
        }
        ListInventoryEntriesResponse other = (ListInventoryEntriesResponse) obj;
        return Objects.equals(typeName(), other.typeName()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(schemaVersion(), other.schemaVersion()) && Objects.equals(captureTime(), other.captureTime())
                && Objects.equals(entries(), other.entries()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (typeName() != null) {
            sb.append("TypeName: ").append(typeName()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (schemaVersion() != null) {
            sb.append("SchemaVersion: ").append(schemaVersion()).append(",");
        }
        if (captureTime() != null) {
            sb.append("CaptureTime: ").append(captureTime()).append(",");
        }
        if (entries() != null) {
            sb.append("Entries: ").append(entries()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeName":
            return Optional.of(clazz.cast(typeName()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "SchemaVersion":
            return Optional.of(clazz.cast(schemaVersion()));
        case "CaptureTime":
            return Optional.of(clazz.cast(captureTime()));
        case "Entries":
            return Optional.of(clazz.cast(entries()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListInventoryEntriesResponse> {
        /**
         * <p>
         * The type of inventory item returned by the request.
         * </p>
         * 
         * @param typeName
         *        The type of inventory item returned by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The instance ID targeted by the request to query inventory information.
         * </p>
         * 
         * @param instanceId
         *        The instance ID targeted by the request to query inventory information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The inventory schema version used by the instance(s).
         * </p>
         * 
         * @param schemaVersion
         *        The inventory schema version used by the instance(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersion(String schemaVersion);

        /**
         * <p>
         * The time that inventory information was collected for the instance(s).
         * </p>
         * 
         * @param captureTime
         *        The time that inventory information was collected for the instance(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captureTime(String captureTime);

        /**
         * <p>
         * A list of inventory items on the instance(s).
         * </p>
         * 
         * @param entries
         *        A list of inventory items on the instance(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<Map<String, String>> entries);

        /**
         * <p>
         * A list of inventory items on the instance(s).
         * </p>
         * 
         * @param entries
         *        A list of inventory items on the instance(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Map<String, String>... entries);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private String typeName;

        private String instanceId;

        private String schemaVersion;

        private String captureTime;

        private List<Map<String, String>> entries;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInventoryEntriesResponse model) {
            typeName(model.typeName);
            instanceId(model.instanceId);
            schemaVersion(model.schemaVersion);
            captureTime(model.captureTime);
            entries(model.entries);
            nextToken(model.nextToken);
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getSchemaVersion() {
            return schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final String getCaptureTime() {
            return captureTime;
        }

        @Override
        public final Builder captureTime(String captureTime) {
            this.captureTime = captureTime;
            return this;
        }

        public final void setCaptureTime(String captureTime) {
            this.captureTime = captureTime;
        }

        public final Collection<Map<String, String>> getEntries() {
            return entries;
        }

        @Override
        public final Builder entries(Collection<Map<String, String>> entries) {
            this.entries = InventoryItemEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Map<String, String>... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        public final void setEntries(Collection<Map<String, String>> entries) {
            this.entries = InventoryItemEntryListCopier.copy(entries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListInventoryEntriesResponse build() {
            return new ListInventoryEntriesResponse(this);
        }
    }
}
