/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowAutomationParametersMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for an AUTOMATION task type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MaintenanceWindowAutomationParameters implements StructuredPojo,
        ToCopyableBuilder<MaintenanceWindowAutomationParameters.Builder, MaintenanceWindowAutomationParameters> {
    private final String documentVersion;

    private final Map<String, List<String>> parameters;

    private MaintenanceWindowAutomationParameters(BuilderImpl builder) {
        this.documentVersion = builder.documentVersion;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The version of an Automation document to use during task execution.
     * </p>
     * 
     * @return The version of an Automation document to use during task execution.
     */
    public String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * The parameters for the AUTOMATION task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The parameters for the AUTOMATION task.
     */
    public Map<String, List<String>> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowAutomationParameters)) {
            return false;
        }
        MaintenanceWindowAutomationParameters other = (MaintenanceWindowAutomationParameters) obj;
        return Objects.equals(documentVersion(), other.documentVersion()) && Objects.equals(parameters(), other.parameters());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (documentVersion() != null) {
            sb.append("DocumentVersion: ").append(documentVersion()).append(",");
        }
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentVersion":
            return Optional.of(clazz.cast(documentVersion()));
        case "Parameters":
            return Optional.of(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowAutomationParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MaintenanceWindowAutomationParameters> {
        /**
         * <p>
         * The version of an Automation document to use during task execution.
         * </p>
         * 
         * @param documentVersion
         *        The version of an Automation document to use during task execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * The parameters for the AUTOMATION task.
         * </p>
         * 
         * @param parameters
         *        The parameters for the AUTOMATION task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, ? extends Collection<String>> parameters);
    }

    static final class BuilderImpl implements Builder {
        private String documentVersion;

        private Map<String, List<String>> parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowAutomationParameters model) {
            documentVersion(model.documentVersion);
            parameters(model.parameters);
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
        }

        @Override
        public MaintenanceWindowAutomationParameters build() {
            return new MaintenanceWindowAutomationParameters(this);
        }
    }
}
