/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowLambdaParametersMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for a LAMBDA task type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MaintenanceWindowLambdaParameters implements StructuredPojo,
        ToCopyableBuilder<MaintenanceWindowLambdaParameters.Builder, MaintenanceWindowLambdaParameters> {
    private final String clientContext;

    private final String qualifier;

    private final ByteBuffer payload;

    private MaintenanceWindowLambdaParameters(BuilderImpl builder) {
        this.clientContext = builder.clientContext;
        this.qualifier = builder.qualifier;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * Pass client-specific information to the Lambda function that you are invoking. You can then process the client
     * information in your Lambda function as you choose through the context variable.
     * </p>
     * 
     * @return Pass client-specific information to the Lambda function that you are invoking. You can then process the
     *         client information in your Lambda function as you choose through the context variable.
     */
    public String clientContext() {
        return clientContext;
    }

    /**
     * <p>
     * (Optional) Specify a Lambda function version or alias name. If you specify a function version, the action uses
     * the qualified function ARN to invoke a specific Lambda function. If you specify an alias name, the action uses
     * the alias ARN to invoke the Lambda function version to which the alias points.
     * </p>
     * 
     * @return (Optional) Specify a Lambda function version or alias name. If you specify a function version, the action
     *         uses the qualified function ARN to invoke a specific Lambda function. If you specify an alias name, the
     *         action uses the alias ARN to invoke the Lambda function version to which the alias points.
     */
    public String qualifier() {
        return qualifier;
    }

    /**
     * <p>
     * JSON to provide to your Lambda function as input.
     * </p>
     * <p>
     * This method will return a new read-only {@code ByteBuffer} each time it is invoked.
     * </p>
     * 
     * @return JSON to provide to your Lambda function as input.
     */
    public ByteBuffer payload() {
        return payload == null ? null : payload.asReadOnlyBuffer();
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientContext());
        hashCode = 31 * hashCode + Objects.hashCode(qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowLambdaParameters)) {
            return false;
        }
        MaintenanceWindowLambdaParameters other = (MaintenanceWindowLambdaParameters) obj;
        return Objects.equals(clientContext(), other.clientContext()) && Objects.equals(qualifier(), other.qualifier())
                && Objects.equals(payload(), other.payload());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (clientContext() != null) {
            sb.append("ClientContext: ").append(clientContext()).append(",");
        }
        if (qualifier() != null) {
            sb.append("Qualifier: ").append(qualifier()).append(",");
        }
        if (payload() != null) {
            sb.append("Payload: ").append(payload()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientContext":
            return Optional.of(clazz.cast(clientContext()));
        case "Qualifier":
            return Optional.of(clazz.cast(qualifier()));
        case "Payload":
            return Optional.of(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowLambdaParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MaintenanceWindowLambdaParameters> {
        /**
         * <p>
         * Pass client-specific information to the Lambda function that you are invoking. You can then process the
         * client information in your Lambda function as you choose through the context variable.
         * </p>
         * 
         * @param clientContext
         *        Pass client-specific information to the Lambda function that you are invoking. You can then process
         *        the client information in your Lambda function as you choose through the context variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientContext(String clientContext);

        /**
         * <p>
         * (Optional) Specify a Lambda function version or alias name. If you specify a function version, the action
         * uses the qualified function ARN to invoke a specific Lambda function. If you specify an alias name, the
         * action uses the alias ARN to invoke the Lambda function version to which the alias points.
         * </p>
         * 
         * @param qualifier
         *        (Optional) Specify a Lambda function version or alias name. If you specify a function version, the
         *        action uses the qualified function ARN to invoke a specific Lambda function. If you specify an alias
         *        name, the action uses the alias ARN to invoke the Lambda function version to which the alias points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualifier(String qualifier);

        /**
         * <p>
         * JSON to provide to your Lambda function as input.
         * </p>
         * <p>
         * To preserve immutability, the remaining bytes in the provided buffer will be copied into a new buffer when
         * set.
         * </p>
         *
         * @param payload
         *        JSON to provide to your Lambda function as input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(ByteBuffer payload);
    }

    static final class BuilderImpl implements Builder {
        private String clientContext;

        private String qualifier;

        private ByteBuffer payload;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowLambdaParameters model) {
            clientContext(model.clientContext);
            qualifier(model.qualifier);
            payload(model.payload);
        }

        public final String getClientContext() {
            return clientContext;
        }

        @Override
        public final Builder clientContext(String clientContext) {
            this.clientContext = clientContext;
            return this;
        }

        public final void setClientContext(String clientContext) {
            this.clientContext = clientContext;
        }

        public final String getQualifier() {
            return qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        public final ByteBuffer getPayload() {
            return payload;
        }

        @Override
        public final Builder payload(ByteBuffer payload) {
            this.payload = StandardMemberCopier.copy(payload);
            return this;
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload = StandardMemberCopier.copy(payload);
        }

        @Override
        public MaintenanceWindowLambdaParameters build() {
            return new MaintenanceWindowLambdaParameters(this);
        }
    }
}
