/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RegisterTargetWithMaintenanceWindowRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RegisterTargetWithMaintenanceWindowRequest.Builder, RegisterTargetWithMaintenanceWindowRequest> {
    private final String windowId;

    private final String resourceType;

    private final List<Target> targets;

    private final String ownerInformation;

    private final String name;

    private final String description;

    private final String clientToken;

    private RegisterTargetWithMaintenanceWindowRequest(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.resourceType = builder.resourceType;
        this.targets = builder.targets;
        this.ownerInformation = builder.ownerInformation;
        this.name = builder.name;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the Maintenance Window the target should be registered with.
     * </p>
     * 
     * @return The ID of the Maintenance Window the target should be registered with.
     */
    public String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The type of target being registered with the Maintenance Window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link MaintenanceWindowResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of target being registered with the Maintenance Window.
     * @see MaintenanceWindowResourceType
     */
    public MaintenanceWindowResourceType resourceType() {
        return MaintenanceWindowResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of target being registered with the Maintenance Window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link MaintenanceWindowResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of target being registered with the Maintenance Window.
     * @see MaintenanceWindowResourceType
     */
    public String resourceTypeString() {
        return resourceType;
    }

    /**
     * <p>
     * The targets (either instances or tags). Instances are specified using
     * Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag
     * name&gt;,Values=&lt;tag value&gt;.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The targets (either instances or tags). Instances are specified using
     *         Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag
     *         name&gt;,Values=&lt;tag value&gt;.
     */
    public List<Target> targets() {
        return targets;
    }

    /**
     * <p>
     * User-provided value that will be included in any CloudWatch events raised while running tasks for these targets
     * in this Maintenance Window.
     * </p>
     * 
     * @return User-provided value that will be included in any CloudWatch events raised while running tasks for these
     *         targets in this Maintenance Window.
     */
    public String ownerInformation() {
        return ownerInformation;
    }

    /**
     * <p>
     * An optional name for the target.
     * </p>
     * 
     * @return An optional name for the target.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * An optional description for the target.
     * </p>
     * 
     * @return An optional description for the target.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * User-provided idempotency token.
     * </p>
     * 
     * @return User-provided idempotency token.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(targets());
        hashCode = 31 * hashCode + Objects.hashCode(ownerInformation());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTargetWithMaintenanceWindowRequest)) {
            return false;
        }
        RegisterTargetWithMaintenanceWindowRequest other = (RegisterTargetWithMaintenanceWindowRequest) obj;
        return Objects.equals(windowId(), other.windowId()) && Objects.equals(resourceTypeString(), other.resourceTypeString())
                && Objects.equals(targets(), other.targets()) && Objects.equals(ownerInformation(), other.ownerInformation())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(clientToken(), other.clientToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (windowId() != null) {
            sb.append("WindowId: ").append(windowId()).append(",");
        }
        if (resourceTypeString() != null) {
            sb.append("ResourceType: ").append(resourceTypeString()).append(",");
        }
        if (targets() != null) {
            sb.append("Targets: ").append(targets()).append(",");
        }
        if (ownerInformation() != null) {
            sb.append("OwnerInformation: ").append(ownerInformation()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.of(clazz.cast(windowId()));
        case "ResourceType":
            return Optional.of(clazz.cast(resourceTypeString()));
        case "Targets":
            return Optional.of(clazz.cast(targets()));
        case "OwnerInformation":
            return Optional.of(clazz.cast(ownerInformation()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RegisterTargetWithMaintenanceWindowRequest> {
        /**
         * <p>
         * The ID of the Maintenance Window the target should be registered with.
         * </p>
         * 
         * @param windowId
         *        The ID of the Maintenance Window the target should be registered with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The type of target being registered with the Maintenance Window.
         * </p>
         * 
         * @param resourceType
         *        The type of target being registered with the Maintenance Window.
         * @see MaintenanceWindowResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of target being registered with the Maintenance Window.
         * </p>
         * 
         * @param resourceType
         *        The type of target being registered with the Maintenance Window.
         * @see MaintenanceWindowResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowResourceType
         */
        Builder resourceType(MaintenanceWindowResourceType resourceType);

        /**
         * <p>
         * The targets (either instances or tags). Instances are specified using
         * Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag
         * name&gt;,Values=&lt;tag value&gt;.
         * </p>
         * 
         * @param targets
         *        The targets (either instances or tags). Instances are specified using
         *        Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag
         *        name&gt;,Values=&lt;tag value&gt;.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * The targets (either instances or tags). Instances are specified using
         * Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag
         * name&gt;,Values=&lt;tag value&gt;.
         * </p>
         * 
         * @param targets
         *        The targets (either instances or tags). Instances are specified using
         *        Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag
         *        name&gt;,Values=&lt;tag value&gt;.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);

        /**
         * <p>
         * User-provided value that will be included in any CloudWatch events raised while running tasks for these
         * targets in this Maintenance Window.
         * </p>
         * 
         * @param ownerInformation
         *        User-provided value that will be included in any CloudWatch events raised while running tasks for
         *        these targets in this Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerInformation(String ownerInformation);

        /**
         * <p>
         * An optional name for the target.
         * </p>
         * 
         * @param name
         *        An optional name for the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An optional description for the target.
         * </p>
         * 
         * @param description
         *        An optional description for the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * User-provided idempotency token.
         * </p>
         * 
         * @param clientToken
         *        User-provided idempotency token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    static final class BuilderImpl implements Builder {
        private String windowId;

        private String resourceType;

        private List<Target> targets;

        private String ownerInformation;

        private String name;

        private String description;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTargetWithMaintenanceWindowRequest model) {
            windowId(model.windowId);
            resourceType(model.resourceType);
            targets(model.targets);
            ownerInformation(model.ownerInformation);
            name(model.name);
            description(model.description);
            clientToken(model.clientToken);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(MaintenanceWindowResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<Target.Builder> getTargets() {
            return targets != null ? targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final String getOwnerInformation() {
            return ownerInformation;
        }

        @Override
        public final Builder ownerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
            return this;
        }

        public final void setOwnerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public RegisterTargetWithMaintenanceWindowRequest build() {
            return new RegisterTargetWithMaintenanceWindowRequest(this);
        }
    }
}
