/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class StartAutomationExecutionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<StartAutomationExecutionRequest.Builder, StartAutomationExecutionRequest> {
    private final String documentName;

    private final String documentVersion;

    private final Map<String, List<String>> parameters;

    private final String clientToken;

    private StartAutomationExecutionRequest(BuilderImpl builder) {
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.parameters = builder.parameters;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the Automation document to use for this execution.
     * </p>
     * 
     * @return The name of the Automation document to use for this execution.
     */
    public String documentName() {
        return documentName;
    }

    /**
     * <p>
     * The version of the Automation document to use for this execution.
     * </p>
     * 
     * @return The version of the Automation document to use for this execution.
     */
    public String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * A key-value map of execution parameters, which match the declared parameters in the Automation document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A key-value map of execution parameters, which match the declared parameters in the Automation document.
     */
    public Map<String, List<String>> parameters() {
        return parameters;
    }

    /**
     * <p>
     * User-provided idempotency token. The token must be unique, is case insensitive, enforces the UUID format, and
     * can't be reused.
     * </p>
     * 
     * @return User-provided idempotency token. The token must be unique, is case insensitive, enforces the UUID format,
     *         and can't be reused.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentName());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAutomationExecutionRequest)) {
            return false;
        }
        StartAutomationExecutionRequest other = (StartAutomationExecutionRequest) obj;
        return Objects.equals(documentName(), other.documentName()) && Objects.equals(documentVersion(), other.documentVersion())
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(clientToken(), other.clientToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (documentName() != null) {
            sb.append("DocumentName: ").append(documentName()).append(",");
        }
        if (documentVersion() != null) {
            sb.append("DocumentVersion: ").append(documentVersion()).append(",");
        }
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentName":
            return Optional.of(clazz.cast(documentName()));
        case "DocumentVersion":
            return Optional.of(clazz.cast(documentVersion()));
        case "Parameters":
            return Optional.of(clazz.cast(parameters()));
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, StartAutomationExecutionRequest> {
        /**
         * <p>
         * The name of the Automation document to use for this execution.
         * </p>
         * 
         * @param documentName
         *        The name of the Automation document to use for this execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentName(String documentName);

        /**
         * <p>
         * The version of the Automation document to use for this execution.
         * </p>
         * 
         * @param documentVersion
         *        The version of the Automation document to use for this execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * A key-value map of execution parameters, which match the declared parameters in the Automation document.
         * </p>
         * 
         * @param parameters
         *        A key-value map of execution parameters, which match the declared parameters in the Automation
         *        document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, ? extends Collection<String>> parameters);

        /**
         * <p>
         * User-provided idempotency token. The token must be unique, is case insensitive, enforces the UUID format, and
         * can't be reused.
         * </p>
         * 
         * @param clientToken
         *        User-provided idempotency token. The token must be unique, is case insensitive, enforces the UUID
         *        format, and can't be reused.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    static final class BuilderImpl implements Builder {
        private String documentName;

        private String documentVersion;

        private Map<String, List<String>> parameters;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAutomationExecutionRequest model) {
            documentName(model.documentName);
            documentVersion(model.documentVersion);
            parameters(model.parameters);
            clientToken(model.clientToken);
        }

        public final String getDocumentName() {
            return documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public StartAutomationExecutionRequest build() {
            return new StartAutomationExecutionRequest(this);
        }
    }
}
