/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class StopAutomationExecutionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<StopAutomationExecutionRequest.Builder, StopAutomationExecutionRequest> {
    private final String automationExecutionId;

    private StopAutomationExecutionRequest(BuilderImpl builder) {
        this.automationExecutionId = builder.automationExecutionId;
    }

    /**
     * <p>
     * The execution ID of the Automation to stop.
     * </p>
     * 
     * @return The execution ID of the Automation to stop.
     */
    public String automationExecutionId() {
        return automationExecutionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automationExecutionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopAutomationExecutionRequest)) {
            return false;
        }
        StopAutomationExecutionRequest other = (StopAutomationExecutionRequest) obj;
        return Objects.equals(automationExecutionId(), other.automationExecutionId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (automationExecutionId() != null) {
            sb.append("AutomationExecutionId: ").append(automationExecutionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomationExecutionId":
            return Optional.of(clazz.cast(automationExecutionId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, StopAutomationExecutionRequest> {
        /**
         * <p>
         * The execution ID of the Automation to stop.
         * </p>
         * 
         * @param automationExecutionId
         *        The execution ID of the Automation to stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationExecutionId(String automationExecutionId);
    }

    static final class BuilderImpl implements Builder {
        private String automationExecutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(StopAutomationExecutionRequest model) {
            automationExecutionId(model.automationExecutionId);
        }

        public final String getAutomationExecutionId() {
            return automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        @Override
        public StopAutomationExecutionRequest build() {
            return new StopAutomationExecutionRequest(this);
        }
    }
}
