/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateMaintenanceWindowRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateMaintenanceWindowRequest.Builder, UpdateMaintenanceWindowRequest> {
    private final String windowId;

    private final String name;

    private final String description;

    private final String schedule;

    private final Integer duration;

    private final Integer cutoff;

    private final Boolean allowUnassociatedTargets;

    private final Boolean enabled;

    private final Boolean replace;

    private UpdateMaintenanceWindowRequest(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.name = builder.name;
        this.description = builder.description;
        this.schedule = builder.schedule;
        this.duration = builder.duration;
        this.cutoff = builder.cutoff;
        this.allowUnassociatedTargets = builder.allowUnassociatedTargets;
        this.enabled = builder.enabled;
        this.replace = builder.replace;
    }

    /**
     * <p>
     * The ID of the Maintenance Window to update.
     * </p>
     * 
     * @return The ID of the Maintenance Window to update.
     */
    public String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The name of the Maintenance Window.
     * </p>
     * 
     * @return The name of the Maintenance Window.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * An optional description for the update request.
     * </p>
     * 
     * @return An optional description for the update request.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The schedule of the Maintenance Window in the form of a cron or rate expression.
     * </p>
     * 
     * @return The schedule of the Maintenance Window in the form of a cron or rate expression.
     */
    public String schedule() {
        return schedule;
    }

    /**
     * <p>
     * The duration of the Maintenance Window in hours.
     * </p>
     * 
     * @return The duration of the Maintenance Window in hours.
     */
    public Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new tasks for
     * execution.
     * </p>
     * 
     * @return The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new
     *         tasks for execution.
     */
    public Integer cutoff() {
        return cutoff;
    }

    /**
     * <p>
     * Whether targets must be registered with the Maintenance Window before tasks can be defined for those targets.
     * </p>
     * 
     * @return Whether targets must be registered with the Maintenance Window before tasks can be defined for those
     *         targets.
     */
    public Boolean allowUnassociatedTargets() {
        return allowUnassociatedTargets;
    }

    /**
     * <p>
     * Whether the Maintenance Window is enabled.
     * </p>
     * 
     * @return Whether the Maintenance Window is enabled.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * If True, then all fields that are required by the CreateMaintenanceWindow action are also required for this API
     * request. Optional fields that are not specified are set to null.
     * </p>
     * 
     * @return If True, then all fields that are required by the CreateMaintenanceWindow action are also required for
     *         this API request. Optional fields that are not specified are set to null.
     */
    public Boolean replace() {
        return replace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(cutoff());
        hashCode = 31 * hashCode + Objects.hashCode(allowUnassociatedTargets());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(replace());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMaintenanceWindowRequest)) {
            return false;
        }
        UpdateMaintenanceWindowRequest other = (UpdateMaintenanceWindowRequest) obj;
        return Objects.equals(windowId(), other.windowId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(schedule(), other.schedule())
                && Objects.equals(duration(), other.duration()) && Objects.equals(cutoff(), other.cutoff())
                && Objects.equals(allowUnassociatedTargets(), other.allowUnassociatedTargets())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(replace(), other.replace());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (windowId() != null) {
            sb.append("WindowId: ").append(windowId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (schedule() != null) {
            sb.append("Schedule: ").append(schedule()).append(",");
        }
        if (duration() != null) {
            sb.append("Duration: ").append(duration()).append(",");
        }
        if (cutoff() != null) {
            sb.append("Cutoff: ").append(cutoff()).append(",");
        }
        if (allowUnassociatedTargets() != null) {
            sb.append("AllowUnassociatedTargets: ").append(allowUnassociatedTargets()).append(",");
        }
        if (enabled() != null) {
            sb.append("Enabled: ").append(enabled()).append(",");
        }
        if (replace() != null) {
            sb.append("Replace: ").append(replace()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.of(clazz.cast(windowId()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Schedule":
            return Optional.of(clazz.cast(schedule()));
        case "Duration":
            return Optional.of(clazz.cast(duration()));
        case "Cutoff":
            return Optional.of(clazz.cast(cutoff()));
        case "AllowUnassociatedTargets":
            return Optional.of(clazz.cast(allowUnassociatedTargets()));
        case "Enabled":
            return Optional.of(clazz.cast(enabled()));
        case "Replace":
            return Optional.of(clazz.cast(replace()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateMaintenanceWindowRequest> {
        /**
         * <p>
         * The ID of the Maintenance Window to update.
         * </p>
         * 
         * @param windowId
         *        The ID of the Maintenance Window to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The name of the Maintenance Window.
         * </p>
         * 
         * @param name
         *        The name of the Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An optional description for the update request.
         * </p>
         * 
         * @param description
         *        An optional description for the update request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The schedule of the Maintenance Window in the form of a cron or rate expression.
         * </p>
         * 
         * @param schedule
         *        The schedule of the Maintenance Window in the form of a cron or rate expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(String schedule);

        /**
         * <p>
         * The duration of the Maintenance Window in hours.
         * </p>
         * 
         * @param duration
         *        The duration of the Maintenance Window in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new tasks
         * for execution.
         * </p>
         * 
         * @param cutoff
         *        The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new
         *        tasks for execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cutoff(Integer cutoff);

        /**
         * <p>
         * Whether targets must be registered with the Maintenance Window before tasks can be defined for those targets.
         * </p>
         * 
         * @param allowUnassociatedTargets
         *        Whether targets must be registered with the Maintenance Window before tasks can be defined for those
         *        targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowUnassociatedTargets(Boolean allowUnassociatedTargets);

        /**
         * <p>
         * Whether the Maintenance Window is enabled.
         * </p>
         * 
         * @param enabled
         *        Whether the Maintenance Window is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * If True, then all fields that are required by the CreateMaintenanceWindow action are also required for this
         * API request. Optional fields that are not specified are set to null.
         * </p>
         * 
         * @param replace
         *        If True, then all fields that are required by the CreateMaintenanceWindow action are also required for
         *        this API request. Optional fields that are not specified are set to null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replace(Boolean replace);
    }

    static final class BuilderImpl implements Builder {
        private String windowId;

        private String name;

        private String description;

        private String schedule;

        private Integer duration;

        private Integer cutoff;

        private Boolean allowUnassociatedTargets;

        private Boolean enabled;

        private Boolean replace;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMaintenanceWindowRequest model) {
            windowId(model.windowId);
            name(model.name);
            description(model.description);
            schedule(model.schedule);
            duration(model.duration);
            cutoff(model.cutoff);
            allowUnassociatedTargets(model.allowUnassociatedTargets);
            enabled(model.enabled);
            replace(model.replace);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSchedule() {
            return schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public final Integer getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Integer getCutoff() {
            return cutoff;
        }

        @Override
        public final Builder cutoff(Integer cutoff) {
            this.cutoff = cutoff;
            return this;
        }

        public final void setCutoff(Integer cutoff) {
            this.cutoff = cutoff;
        }

        public final Boolean getAllowUnassociatedTargets() {
            return allowUnassociatedTargets;
        }

        @Override
        public final Builder allowUnassociatedTargets(Boolean allowUnassociatedTargets) {
            this.allowUnassociatedTargets = allowUnassociatedTargets;
            return this;
        }

        public final void setAllowUnassociatedTargets(Boolean allowUnassociatedTargets) {
            this.allowUnassociatedTargets = allowUnassociatedTargets;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Boolean getReplace() {
            return replace;
        }

        @Override
        public final Builder replace(Boolean replace) {
            this.replace = replace;
            return this;
        }

        public final void setReplace(Boolean replace) {
            this.replace = replace;
        }

        @Override
        public UpdateMaintenanceWindowRequest build() {
            return new UpdateMaintenanceWindowRequest(this);
        }
    }
}
