/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdatePatchBaselineResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<UpdatePatchBaselineResponse.Builder, UpdatePatchBaselineResponse> {
    private final String baselineId;

    private final String name;

    private final String operatingSystem;

    private final PatchFilterGroup globalFilters;

    private final PatchRuleGroup approvalRules;

    private final List<String> approvedPatches;

    private final String approvedPatchesComplianceLevel;

    private final List<String> rejectedPatches;

    private final Instant createdDate;

    private final Instant modifiedDate;

    private final String description;

    private UpdatePatchBaselineResponse(BuilderImpl builder) {
        this.baselineId = builder.baselineId;
        this.name = builder.name;
        this.operatingSystem = builder.operatingSystem;
        this.globalFilters = builder.globalFilters;
        this.approvalRules = builder.approvalRules;
        this.approvedPatches = builder.approvedPatches;
        this.approvedPatchesComplianceLevel = builder.approvedPatchesComplianceLevel;
        this.rejectedPatches = builder.rejectedPatches;
        this.createdDate = builder.createdDate;
        this.modifiedDate = builder.modifiedDate;
        this.description = builder.description;
    }

    /**
     * <p>
     * The ID of the deleted patch baseline.
     * </p>
     * 
     * @return The ID of the deleted patch baseline.
     */
    public String baselineId() {
        return baselineId;
    }

    /**
     * <p>
     * The name of the patch baseline.
     * </p>
     * 
     * @return The name of the patch baseline.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The operating system rule used by the updated patch baseline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemString}.
     * </p>
     * 
     * @return The operating system rule used by the updated patch baseline.
     * @see OperatingSystem
     */
    public OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(operatingSystem);
    }

    /**
     * <p>
     * The operating system rule used by the updated patch baseline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemString}.
     * </p>
     * 
     * @return The operating system rule used by the updated patch baseline.
     * @see OperatingSystem
     */
    public String operatingSystemString() {
        return operatingSystem;
    }

    /**
     * <p>
     * A set of global filters used to exclude patches from the baseline.
     * </p>
     * 
     * @return A set of global filters used to exclude patches from the baseline.
     */
    public PatchFilterGroup globalFilters() {
        return globalFilters;
    }

    /**
     * <p>
     * A set of rules used to include patches in the baseline.
     * </p>
     * 
     * @return A set of rules used to include patches in the baseline.
     */
    public PatchRuleGroup approvalRules() {
        return approvalRules;
    }

    /**
     * <p>
     * A list of explicitly approved patches for the baseline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of explicitly approved patches for the baseline.
     */
    public List<String> approvedPatches() {
        return approvedPatches;
    }

    /**
     * <p>
     * The compliance severity level assigned to the patch baseline after the update completed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #approvedPatchesComplianceLevel} will return {@link PatchComplianceLevel#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #approvedPatchesComplianceLevelString}.
     * </p>
     * 
     * @return The compliance severity level assigned to the patch baseline after the update completed.
     * @see PatchComplianceLevel
     */
    public PatchComplianceLevel approvedPatchesComplianceLevel() {
        return PatchComplianceLevel.fromValue(approvedPatchesComplianceLevel);
    }

    /**
     * <p>
     * The compliance severity level assigned to the patch baseline after the update completed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #approvedPatchesComplianceLevel} will return {@link PatchComplianceLevel#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #approvedPatchesComplianceLevelString}.
     * </p>
     * 
     * @return The compliance severity level assigned to the patch baseline after the update completed.
     * @see PatchComplianceLevel
     */
    public String approvedPatchesComplianceLevelString() {
        return approvedPatchesComplianceLevel;
    }

    /**
     * <p>
     * A list of explicitly rejected patches for the baseline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of explicitly rejected patches for the baseline.
     */
    public List<String> rejectedPatches() {
        return rejectedPatches;
    }

    /**
     * <p>
     * The date when the patch baseline was created.
     * </p>
     * 
     * @return The date when the patch baseline was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The date when the patch baseline was last modified.
     * </p>
     * 
     * @return The date when the patch baseline was last modified.
     */
    public Instant modifiedDate() {
        return modifiedDate;
    }

    /**
     * <p>
     * A description of the Patch Baseline.
     * </p>
     * 
     * @return A description of the Patch Baseline.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baselineId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemString());
        hashCode = 31 * hashCode + Objects.hashCode(globalFilters());
        hashCode = 31 * hashCode + Objects.hashCode(approvalRules());
        hashCode = 31 * hashCode + Objects.hashCode(approvedPatches());
        hashCode = 31 * hashCode + Objects.hashCode(approvedPatchesComplianceLevelString());
        hashCode = 31 * hashCode + Objects.hashCode(rejectedPatches());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePatchBaselineResponse)) {
            return false;
        }
        UpdatePatchBaselineResponse other = (UpdatePatchBaselineResponse) obj;
        return Objects.equals(baselineId(), other.baselineId()) && Objects.equals(name(), other.name())
                && Objects.equals(operatingSystemString(), other.operatingSystemString())
                && Objects.equals(globalFilters(), other.globalFilters())
                && Objects.equals(approvalRules(), other.approvalRules())
                && Objects.equals(approvedPatches(), other.approvedPatches())
                && Objects.equals(approvedPatchesComplianceLevelString(), other.approvedPatchesComplianceLevelString())
                && Objects.equals(rejectedPatches(), other.rejectedPatches())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(modifiedDate(), other.modifiedDate())
                && Objects.equals(description(), other.description());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (baselineId() != null) {
            sb.append("BaselineId: ").append(baselineId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (operatingSystemString() != null) {
            sb.append("OperatingSystem: ").append(operatingSystemString()).append(",");
        }
        if (globalFilters() != null) {
            sb.append("GlobalFilters: ").append(globalFilters()).append(",");
        }
        if (approvalRules() != null) {
            sb.append("ApprovalRules: ").append(approvalRules()).append(",");
        }
        if (approvedPatches() != null) {
            sb.append("ApprovedPatches: ").append(approvedPatches()).append(",");
        }
        if (approvedPatchesComplianceLevelString() != null) {
            sb.append("ApprovedPatchesComplianceLevel: ").append(approvedPatchesComplianceLevelString()).append(",");
        }
        if (rejectedPatches() != null) {
            sb.append("RejectedPatches: ").append(rejectedPatches()).append(",");
        }
        if (createdDate() != null) {
            sb.append("CreatedDate: ").append(createdDate()).append(",");
        }
        if (modifiedDate() != null) {
            sb.append("ModifiedDate: ").append(modifiedDate()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaselineId":
            return Optional.of(clazz.cast(baselineId()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "OperatingSystem":
            return Optional.of(clazz.cast(operatingSystemString()));
        case "GlobalFilters":
            return Optional.of(clazz.cast(globalFilters()));
        case "ApprovalRules":
            return Optional.of(clazz.cast(approvalRules()));
        case "ApprovedPatches":
            return Optional.of(clazz.cast(approvedPatches()));
        case "ApprovedPatchesComplianceLevel":
            return Optional.of(clazz.cast(approvedPatchesComplianceLevelString()));
        case "RejectedPatches":
            return Optional.of(clazz.cast(rejectedPatches()));
        case "CreatedDate":
            return Optional.of(clazz.cast(createdDate()));
        case "ModifiedDate":
            return Optional.of(clazz.cast(modifiedDate()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdatePatchBaselineResponse> {
        /**
         * <p>
         * The ID of the deleted patch baseline.
         * </p>
         * 
         * @param baselineId
         *        The ID of the deleted patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineId(String baselineId);

        /**
         * <p>
         * The name of the patch baseline.
         * </p>
         * 
         * @param name
         *        The name of the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The operating system rule used by the updated patch baseline.
         * </p>
         * 
         * @param operatingSystem
         *        The operating system rule used by the updated patch baseline.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(String operatingSystem);

        /**
         * <p>
         * The operating system rule used by the updated patch baseline.
         * </p>
         * 
         * @param operatingSystem
         *        The operating system rule used by the updated patch baseline.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(OperatingSystem operatingSystem);

        /**
         * <p>
         * A set of global filters used to exclude patches from the baseline.
         * </p>
         * 
         * @param globalFilters
         *        A set of global filters used to exclude patches from the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalFilters(PatchFilterGroup globalFilters);

        /**
         * <p>
         * A set of global filters used to exclude patches from the baseline.
         * </p>
         * This is a convenience that creates an instance of the {@link PatchFilterGroup.Builder} avoiding the need to
         * create one manually via {@link PatchFilterGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link PatchFilterGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #globalFilters(PatchFilterGroup)}.
         * 
         * @param globalFilters
         *        a consumer that will call methods on {@link PatchFilterGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalFilters(PatchFilterGroup)
         */
        default Builder globalFilters(Consumer<PatchFilterGroup.Builder> globalFilters) {
            return globalFilters(PatchFilterGroup.builder().apply(globalFilters).build());
        }

        /**
         * <p>
         * A set of rules used to include patches in the baseline.
         * </p>
         * 
         * @param approvalRules
         *        A set of rules used to include patches in the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRules(PatchRuleGroup approvalRules);

        /**
         * <p>
         * A set of rules used to include patches in the baseline.
         * </p>
         * This is a convenience that creates an instance of the {@link PatchRuleGroup.Builder} avoiding the need to
         * create one manually via {@link PatchRuleGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link PatchRuleGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #approvalRules(PatchRuleGroup)}.
         * 
         * @param approvalRules
         *        a consumer that will call methods on {@link PatchRuleGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #approvalRules(PatchRuleGroup)
         */
        default Builder approvalRules(Consumer<PatchRuleGroup.Builder> approvalRules) {
            return approvalRules(PatchRuleGroup.builder().apply(approvalRules).build());
        }

        /**
         * <p>
         * A list of explicitly approved patches for the baseline.
         * </p>
         * 
         * @param approvedPatches
         *        A list of explicitly approved patches for the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvedPatches(Collection<String> approvedPatches);

        /**
         * <p>
         * A list of explicitly approved patches for the baseline.
         * </p>
         * 
         * @param approvedPatches
         *        A list of explicitly approved patches for the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvedPatches(String... approvedPatches);

        /**
         * <p>
         * The compliance severity level assigned to the patch baseline after the update completed.
         * </p>
         * 
         * @param approvedPatchesComplianceLevel
         *        The compliance severity level assigned to the patch baseline after the update completed.
         * @see PatchComplianceLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchComplianceLevel
         */
        Builder approvedPatchesComplianceLevel(String approvedPatchesComplianceLevel);

        /**
         * <p>
         * The compliance severity level assigned to the patch baseline after the update completed.
         * </p>
         * 
         * @param approvedPatchesComplianceLevel
         *        The compliance severity level assigned to the patch baseline after the update completed.
         * @see PatchComplianceLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchComplianceLevel
         */
        Builder approvedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel);

        /**
         * <p>
         * A list of explicitly rejected patches for the baseline.
         * </p>
         * 
         * @param rejectedPatches
         *        A list of explicitly rejected patches for the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectedPatches(Collection<String> rejectedPatches);

        /**
         * <p>
         * A list of explicitly rejected patches for the baseline.
         * </p>
         * 
         * @param rejectedPatches
         *        A list of explicitly rejected patches for the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectedPatches(String... rejectedPatches);

        /**
         * <p>
         * The date when the patch baseline was created.
         * </p>
         * 
         * @param createdDate
         *        The date when the patch baseline was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The date when the patch baseline was last modified.
         * </p>
         * 
         * @param modifiedDate
         *        The date when the patch baseline was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedDate(Instant modifiedDate);

        /**
         * <p>
         * A description of the Patch Baseline.
         * </p>
         * 
         * @param description
         *        A description of the Patch Baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String baselineId;

        private String name;

        private String operatingSystem;

        private PatchFilterGroup globalFilters;

        private PatchRuleGroup approvalRules;

        private List<String> approvedPatches;

        private String approvedPatchesComplianceLevel;

        private List<String> rejectedPatches;

        private Instant createdDate;

        private Instant modifiedDate;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePatchBaselineResponse model) {
            baselineId(model.baselineId);
            name(model.name);
            operatingSystem(model.operatingSystem);
            globalFilters(model.globalFilters);
            approvalRules(model.approvalRules);
            approvedPatches(model.approvedPatches);
            approvedPatchesComplianceLevel(model.approvedPatchesComplianceLevel);
            rejectedPatches(model.rejectedPatches);
            createdDate(model.createdDate);
            modifiedDate(model.modifiedDate);
            description(model.description);
        }

        public final String getBaselineId() {
            return baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOperatingSystem() {
            return operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        public final PatchFilterGroup.Builder getGlobalFilters() {
            return globalFilters != null ? globalFilters.toBuilder() : null;
        }

        @Override
        public final Builder globalFilters(PatchFilterGroup globalFilters) {
            this.globalFilters = globalFilters;
            return this;
        }

        public final void setGlobalFilters(PatchFilterGroup.BuilderImpl globalFilters) {
            this.globalFilters = globalFilters != null ? globalFilters.build() : null;
        }

        public final PatchRuleGroup.Builder getApprovalRules() {
            return approvalRules != null ? approvalRules.toBuilder() : null;
        }

        @Override
        public final Builder approvalRules(PatchRuleGroup approvalRules) {
            this.approvalRules = approvalRules;
            return this;
        }

        public final void setApprovalRules(PatchRuleGroup.BuilderImpl approvalRules) {
            this.approvalRules = approvalRules != null ? approvalRules.build() : null;
        }

        public final Collection<String> getApprovedPatches() {
            return approvedPatches;
        }

        @Override
        public final Builder approvedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvedPatches(String... approvedPatches) {
            approvedPatches(Arrays.asList(approvedPatches));
            return this;
        }

        public final void setApprovedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
        }

        public final String getApprovedPatchesComplianceLevel() {
            return approvedPatchesComplianceLevel;
        }

        @Override
        public final Builder approvedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
            return this;
        }

        @Override
        public final Builder approvedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel(approvedPatchesComplianceLevel.toString());
            return this;
        }

        public final void setApprovedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
        }

        public final Collection<String> getRejectedPatches() {
            return rejectedPatches;
        }

        @Override
        public final Builder rejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectedPatches(String... rejectedPatches) {
            rejectedPatches(Arrays.asList(rejectedPatches));
            return this;
        }

        public final void setRejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Instant getModifiedDate() {
            return modifiedDate;
        }

        @Override
        public final Builder modifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
            return this;
        }

        public final void setModifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public UpdatePatchBaselineResponse build() {
            return new UpdatePatchBaselineResponse(this);
        }
    }
}
