/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.services.ssm.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * MaintenanceWindowExecutionTaskInvocationIdentityMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class MaintenanceWindowExecutionTaskInvocationIdentityMarshaller {

    private static final MarshallingInfo<String> WINDOWEXECUTIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowExecutionId").build();
    private static final MarshallingInfo<String> TASKEXECUTIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskExecutionId").build();
    private static final MarshallingInfo<String> INVOCATIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InvocationId").build();
    private static final MarshallingInfo<String> EXECUTIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionId").build();
    private static final MarshallingInfo<String> TASKTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskType").build();
    private static final MarshallingInfo<String> PARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> STATUSDETAILS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusDetails").build();
    private static final MarshallingInfo<java.time.Instant> STARTTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").build();
    private static final MarshallingInfo<java.time.Instant> ENDTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").build();
    private static final MarshallingInfo<String> OWNERINFORMATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerInformation").build();
    private static final MarshallingInfo<String> WINDOWTARGETID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowTargetId").build();

    private static final MaintenanceWindowExecutionTaskInvocationIdentityMarshaller INSTANCE = new MaintenanceWindowExecutionTaskInvocationIdentityMarshaller();

    public static MaintenanceWindowExecutionTaskInvocationIdentityMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(MaintenanceWindowExecutionTaskInvocationIdentity maintenanceWindowExecutionTaskInvocationIdentity,
            ProtocolMarshaller protocolMarshaller) {

        if (maintenanceWindowExecutionTaskInvocationIdentity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.windowExecutionId(),
                    WINDOWEXECUTIONID_BINDING);

            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.taskExecutionId(),
                    TASKEXECUTIONID_BINDING);

            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.invocationId(), INVOCATIONID_BINDING);

            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.executionId(), EXECUTIONID_BINDING);

            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.taskTypeString(), TASKTYPE_BINDING);

            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.parameters(), PARAMETERS_BINDING);

            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.statusString(), STATUS_BINDING);

            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.statusDetails(), STATUSDETAILS_BINDING);

            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.startTime(), STARTTIME_BINDING);

            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.endTime(), ENDTIME_BINDING);

            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.ownerInformation(),
                    OWNERINFORMATION_BINDING);

            protocolMarshaller
                    .marshall(maintenanceWindowExecutionTaskInvocationIdentity.windowTargetId(), WINDOWTARGETID_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
