/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.services.ssm.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * ResourceComplianceSummaryItemMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class ResourceComplianceSummaryItemMarshaller {

    private static final MarshallingInfo<String> COMPLIANCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceType").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceId").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> OVERALLSEVERITY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OverallSeverity").build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONSUMMARY_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ExecutionSummary").build();
    private static final MarshallingInfo<StructuredPojo> COMPLIANTSUMMARY_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("CompliantSummary").build();
    private static final MarshallingInfo<StructuredPojo> NONCOMPLIANTSUMMARY_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("NonCompliantSummary").build();

    private static final ResourceComplianceSummaryItemMarshaller INSTANCE = new ResourceComplianceSummaryItemMarshaller();

    public static ResourceComplianceSummaryItemMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(ResourceComplianceSummaryItem resourceComplianceSummaryItem, ProtocolMarshaller protocolMarshaller) {

        if (resourceComplianceSummaryItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(resourceComplianceSummaryItem.complianceType(), COMPLIANCETYPE_BINDING);

            protocolMarshaller.marshall(resourceComplianceSummaryItem.resourceType(), RESOURCETYPE_BINDING);

            protocolMarshaller.marshall(resourceComplianceSummaryItem.resourceId(), RESOURCEID_BINDING);

            protocolMarshaller.marshall(resourceComplianceSummaryItem.statusString(), STATUS_BINDING);

            protocolMarshaller.marshall(resourceComplianceSummaryItem.overallSeverityString(), OVERALLSEVERITY_BINDING);

            protocolMarshaller.marshall(resourceComplianceSummaryItem.executionSummary(), EXECUTIONSUMMARY_BINDING);

            protocolMarshaller.marshall(resourceComplianceSummaryItem.compliantSummary(), COMPLIANTSUMMARY_BINDING);

            protocolMarshaller.marshall(resourceComplianceSummaryItem.nonCompliantSummary(), NONCOMPLIANTSUMMARY_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
