/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.ActivationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Activation
implements StructuredPojo,
ToCopyableBuilder<Builder, Activation> {
    private final String activationId;
    private final String description;
    private final String defaultInstanceName;
    private final String iamRole;
    private final Integer registrationLimit;
    private final Integer registrationsCount;
    private final Instant expirationDate;
    private final Boolean expired;
    private final Instant createdDate;

    private Activation(BuilderImpl builder) {
        this.activationId = builder.activationId;
        this.description = builder.description;
        this.defaultInstanceName = builder.defaultInstanceName;
        this.iamRole = builder.iamRole;
        this.registrationLimit = builder.registrationLimit;
        this.registrationsCount = builder.registrationsCount;
        this.expirationDate = builder.expirationDate;
        this.expired = builder.expired;
        this.createdDate = builder.createdDate;
    }

    public String activationId() {
        return this.activationId;
    }

    public String description() {
        return this.description;
    }

    public String defaultInstanceName() {
        return this.defaultInstanceName;
    }

    public String iamRole() {
        return this.iamRole;
    }

    public Integer registrationLimit() {
        return this.registrationLimit;
    }

    public Integer registrationsCount() {
        return this.registrationsCount;
    }

    public Instant expirationDate() {
        return this.expirationDate;
    }

    public Boolean expired() {
        return this.expired;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.expired());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Activation)) {
            return false;
        }
        Activation other = (Activation)obj;
        return Objects.equals(this.activationId(), other.activationId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.defaultInstanceName(), other.defaultInstanceName()) && Objects.equals(this.iamRole(), other.iamRole()) && Objects.equals(this.registrationLimit(), other.registrationLimit()) && Objects.equals(this.registrationsCount(), other.registrationsCount()) && Objects.equals(this.expirationDate(), other.expirationDate()) && Objects.equals(this.expired(), other.expired()) && Objects.equals(this.createdDate(), other.createdDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.activationId() != null) {
            sb.append("ActivationId: ").append(this.activationId()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.defaultInstanceName() != null) {
            sb.append("DefaultInstanceName: ").append(this.defaultInstanceName()).append(",");
        }
        if (this.iamRole() != null) {
            sb.append("IamRole: ").append(this.iamRole()).append(",");
        }
        if (this.registrationLimit() != null) {
            sb.append("RegistrationLimit: ").append(this.registrationLimit()).append(",");
        }
        if (this.registrationsCount() != null) {
            sb.append("RegistrationsCount: ").append(this.registrationsCount()).append(",");
        }
        if (this.expirationDate() != null) {
            sb.append("ExpirationDate: ").append(this.expirationDate()).append(",");
        }
        if (this.expired() != null) {
            sb.append("Expired: ").append(this.expired()).append(",");
        }
        if (this.createdDate() != null) {
            sb.append("CreatedDate: ").append(this.createdDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivationId": {
                return Optional.of(clazz.cast(this.activationId()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "DefaultInstanceName": {
                return Optional.of(clazz.cast(this.defaultInstanceName()));
            }
            case "IamRole": {
                return Optional.of(clazz.cast(this.iamRole()));
            }
            case "RegistrationLimit": {
                return Optional.of(clazz.cast(this.registrationLimit()));
            }
            case "RegistrationsCount": {
                return Optional.of(clazz.cast(this.registrationsCount()));
            }
            case "ExpirationDate": {
                return Optional.of(clazz.cast(this.expirationDate()));
            }
            case "Expired": {
                return Optional.of(clazz.cast(this.expired()));
            }
            case "CreatedDate": {
                return Optional.of(clazz.cast(this.createdDate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActivationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String activationId;
        private String description;
        private String defaultInstanceName;
        private String iamRole;
        private Integer registrationLimit;
        private Integer registrationsCount;
        private Instant expirationDate;
        private Boolean expired;
        private Instant createdDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Activation model) {
            this.activationId(model.activationId);
            this.description(model.description);
            this.defaultInstanceName(model.defaultInstanceName);
            this.iamRole(model.iamRole);
            this.registrationLimit(model.registrationLimit);
            this.registrationsCount(model.registrationsCount);
            this.expirationDate(model.expirationDate);
            this.expired(model.expired);
            this.createdDate(model.createdDate);
        }

        public final String getActivationId() {
            return this.activationId;
        }

        @Override
        public final Builder activationId(String activationId) {
            this.activationId = activationId;
            return this;
        }

        public final void setActivationId(String activationId) {
            this.activationId = activationId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDefaultInstanceName() {
            return this.defaultInstanceName;
        }

        @Override
        public final Builder defaultInstanceName(String defaultInstanceName) {
            this.defaultInstanceName = defaultInstanceName;
            return this;
        }

        public final void setDefaultInstanceName(String defaultInstanceName) {
            this.defaultInstanceName = defaultInstanceName;
        }

        public final String getIamRole() {
            return this.iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        public final Integer getRegistrationLimit() {
            return this.registrationLimit;
        }

        @Override
        public final Builder registrationLimit(Integer registrationLimit) {
            this.registrationLimit = registrationLimit;
            return this;
        }

        public final void setRegistrationLimit(Integer registrationLimit) {
            this.registrationLimit = registrationLimit;
        }

        public final Integer getRegistrationsCount() {
            return this.registrationsCount;
        }

        @Override
        public final Builder registrationsCount(Integer registrationsCount) {
            this.registrationsCount = registrationsCount;
            return this;
        }

        public final void setRegistrationsCount(Integer registrationsCount) {
            this.registrationsCount = registrationsCount;
        }

        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        public final Boolean getExpired() {
            return this.expired;
        }

        @Override
        public final Builder expired(Boolean expired) {
            this.expired = expired;
            return this;
        }

        public final void setExpired(Boolean expired) {
            this.expired = expired;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public Activation build() {
            return new Activation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Activation> {
        public Builder activationId(String var1);

        public Builder description(String var1);

        public Builder defaultInstanceName(String var1);

        public Builder iamRole(String var1);

        public Builder registrationLimit(Integer var1);

        public Builder registrationsCount(Integer var1);

        public Builder expirationDate(Instant var1);

        public Builder expired(Boolean var1);

        public Builder createdDate(Instant var1);
    }
}

