/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.CommandPluginStatus;
import software.amazon.awssdk.services.ssm.transform.CommandPluginMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CommandPlugin
implements StructuredPojo,
ToCopyableBuilder<Builder, CommandPlugin> {
    private final String name;
    private final String status;
    private final String statusDetails;
    private final Integer responseCode;
    private final Instant responseStartDateTime;
    private final Instant responseFinishDateTime;
    private final String output;
    private final String standardOutputUrl;
    private final String standardErrorUrl;
    private final String outputS3Region;
    private final String outputS3BucketName;
    private final String outputS3KeyPrefix;

    private CommandPlugin(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.responseCode = builder.responseCode;
        this.responseStartDateTime = builder.responseStartDateTime;
        this.responseFinishDateTime = builder.responseFinishDateTime;
        this.output = builder.output;
        this.standardOutputUrl = builder.standardOutputUrl;
        this.standardErrorUrl = builder.standardErrorUrl;
        this.outputS3Region = builder.outputS3Region;
        this.outputS3BucketName = builder.outputS3BucketName;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
    }

    public String name() {
        return this.name;
    }

    public CommandPluginStatus status() {
        return CommandPluginStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public Integer responseCode() {
        return this.responseCode;
    }

    public Instant responseStartDateTime() {
        return this.responseStartDateTime;
    }

    public Instant responseFinishDateTime() {
        return this.responseFinishDateTime;
    }

    public String output() {
        return this.output;
    }

    public String standardOutputUrl() {
        return this.standardOutputUrl;
    }

    public String standardErrorUrl() {
        return this.standardErrorUrl;
    }

    public String outputS3Region() {
        return this.outputS3Region;
    }

    public String outputS3BucketName() {
        return this.outputS3BucketName;
    }

    public String outputS3KeyPrefix() {
        return this.outputS3KeyPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseStartDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseFinishDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardOutputUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardErrorUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3Region());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3KeyPrefix());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandPlugin)) {
            return false;
        }
        CommandPlugin other = (CommandPlugin)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.responseCode(), other.responseCode()) && Objects.equals(this.responseStartDateTime(), other.responseStartDateTime()) && Objects.equals(this.responseFinishDateTime(), other.responseFinishDateTime()) && Objects.equals(this.output(), other.output()) && Objects.equals(this.standardOutputUrl(), other.standardOutputUrl()) && Objects.equals(this.standardErrorUrl(), other.standardErrorUrl()) && Objects.equals(this.outputS3Region(), other.outputS3Region()) && Objects.equals(this.outputS3BucketName(), other.outputS3BucketName()) && Objects.equals(this.outputS3KeyPrefix(), other.outputS3KeyPrefix());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.statusDetails() != null) {
            sb.append("StatusDetails: ").append(this.statusDetails()).append(",");
        }
        if (this.responseCode() != null) {
            sb.append("ResponseCode: ").append(this.responseCode()).append(",");
        }
        if (this.responseStartDateTime() != null) {
            sb.append("ResponseStartDateTime: ").append(this.responseStartDateTime()).append(",");
        }
        if (this.responseFinishDateTime() != null) {
            sb.append("ResponseFinishDateTime: ").append(this.responseFinishDateTime()).append(",");
        }
        if (this.output() != null) {
            sb.append("Output: ").append(this.output()).append(",");
        }
        if (this.standardOutputUrl() != null) {
            sb.append("StandardOutputUrl: ").append(this.standardOutputUrl()).append(",");
        }
        if (this.standardErrorUrl() != null) {
            sb.append("StandardErrorUrl: ").append(this.standardErrorUrl()).append(",");
        }
        if (this.outputS3Region() != null) {
            sb.append("OutputS3Region: ").append(this.outputS3Region()).append(",");
        }
        if (this.outputS3BucketName() != null) {
            sb.append("OutputS3BucketName: ").append(this.outputS3BucketName()).append(",");
        }
        if (this.outputS3KeyPrefix() != null) {
            sb.append("OutputS3KeyPrefix: ").append(this.outputS3KeyPrefix()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "StatusDetails": {
                return Optional.of(clazz.cast(this.statusDetails()));
            }
            case "ResponseCode": {
                return Optional.of(clazz.cast(this.responseCode()));
            }
            case "ResponseStartDateTime": {
                return Optional.of(clazz.cast(this.responseStartDateTime()));
            }
            case "ResponseFinishDateTime": {
                return Optional.of(clazz.cast(this.responseFinishDateTime()));
            }
            case "Output": {
                return Optional.of(clazz.cast(this.output()));
            }
            case "StandardOutputUrl": {
                return Optional.of(clazz.cast(this.standardOutputUrl()));
            }
            case "StandardErrorUrl": {
                return Optional.of(clazz.cast(this.standardErrorUrl()));
            }
            case "OutputS3Region": {
                return Optional.of(clazz.cast(this.outputS3Region()));
            }
            case "OutputS3BucketName": {
                return Optional.of(clazz.cast(this.outputS3BucketName()));
            }
            case "OutputS3KeyPrefix": {
                return Optional.of(clazz.cast(this.outputS3KeyPrefix()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CommandPluginMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String status;
        private String statusDetails;
        private Integer responseCode;
        private Instant responseStartDateTime;
        private Instant responseFinishDateTime;
        private String output;
        private String standardOutputUrl;
        private String standardErrorUrl;
        private String outputS3Region;
        private String outputS3BucketName;
        private String outputS3KeyPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(CommandPlugin model) {
            this.name(model.name);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.responseCode(model.responseCode);
            this.responseStartDateTime(model.responseStartDateTime);
            this.responseFinishDateTime(model.responseFinishDateTime);
            this.output(model.output);
            this.standardOutputUrl(model.standardOutputUrl);
            this.standardErrorUrl(model.standardErrorUrl);
            this.outputS3Region(model.outputS3Region);
            this.outputS3BucketName(model.outputS3BucketName);
            this.outputS3KeyPrefix(model.outputS3KeyPrefix);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CommandPluginStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final Integer getResponseCode() {
            return this.responseCode;
        }

        @Override
        public final Builder responseCode(Integer responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final void setResponseCode(Integer responseCode) {
            this.responseCode = responseCode;
        }

        public final Instant getResponseStartDateTime() {
            return this.responseStartDateTime;
        }

        @Override
        public final Builder responseStartDateTime(Instant responseStartDateTime) {
            this.responseStartDateTime = responseStartDateTime;
            return this;
        }

        public final void setResponseStartDateTime(Instant responseStartDateTime) {
            this.responseStartDateTime = responseStartDateTime;
        }

        public final Instant getResponseFinishDateTime() {
            return this.responseFinishDateTime;
        }

        @Override
        public final Builder responseFinishDateTime(Instant responseFinishDateTime) {
            this.responseFinishDateTime = responseFinishDateTime;
            return this;
        }

        public final void setResponseFinishDateTime(Instant responseFinishDateTime) {
            this.responseFinishDateTime = responseFinishDateTime;
        }

        public final String getOutput() {
            return this.output;
        }

        @Override
        public final Builder output(String output) {
            this.output = output;
            return this;
        }

        public final void setOutput(String output) {
            this.output = output;
        }

        public final String getStandardOutputUrl() {
            return this.standardOutputUrl;
        }

        @Override
        public final Builder standardOutputUrl(String standardOutputUrl) {
            this.standardOutputUrl = standardOutputUrl;
            return this;
        }

        public final void setStandardOutputUrl(String standardOutputUrl) {
            this.standardOutputUrl = standardOutputUrl;
        }

        public final String getStandardErrorUrl() {
            return this.standardErrorUrl;
        }

        @Override
        public final Builder standardErrorUrl(String standardErrorUrl) {
            this.standardErrorUrl = standardErrorUrl;
            return this;
        }

        public final void setStandardErrorUrl(String standardErrorUrl) {
            this.standardErrorUrl = standardErrorUrl;
        }

        public final String getOutputS3Region() {
            return this.outputS3Region;
        }

        @Override
        public final Builder outputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
            return this;
        }

        public final void setOutputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
        }

        public final String getOutputS3BucketName() {
            return this.outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        public final String getOutputS3KeyPrefix() {
            return this.outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        public CommandPlugin build() {
            return new CommandPlugin(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CommandPlugin> {
        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(CommandPluginStatus var1);

        public Builder statusDetails(String var1);

        public Builder responseCode(Integer var1);

        public Builder responseStartDateTime(Instant var1);

        public Builder responseFinishDateTime(Instant var1);

        public Builder output(String var1);

        public Builder standardOutputUrl(String var1);

        public Builder standardErrorUrl(String var1);

        public Builder outputS3Region(String var1);

        public Builder outputS3BucketName(String var1);

        public Builder outputS3KeyPrefix(String var1);
    }
}

