/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateActivationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateActivationRequest> {
    private final String description;
    private final String defaultInstanceName;
    private final String iamRole;
    private final Integer registrationLimit;
    private final Instant expirationDate;

    private CreateActivationRequest(BuilderImpl builder) {
        this.description = builder.description;
        this.defaultInstanceName = builder.defaultInstanceName;
        this.iamRole = builder.iamRole;
        this.registrationLimit = builder.registrationLimit;
        this.expirationDate = builder.expirationDate;
    }

    public String description() {
        return this.description;
    }

    public String defaultInstanceName() {
        return this.defaultInstanceName;
    }

    public String iamRole() {
        return this.iamRole;
    }

    public Integer registrationLimit() {
        return this.registrationLimit;
    }

    public Instant expirationDate() {
        return this.expirationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateActivationRequest)) {
            return false;
        }
        CreateActivationRequest other = (CreateActivationRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.defaultInstanceName(), other.defaultInstanceName()) && Objects.equals(this.iamRole(), other.iamRole()) && Objects.equals(this.registrationLimit(), other.registrationLimit()) && Objects.equals(this.expirationDate(), other.expirationDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.defaultInstanceName() != null) {
            sb.append("DefaultInstanceName: ").append(this.defaultInstanceName()).append(",");
        }
        if (this.iamRole() != null) {
            sb.append("IamRole: ").append(this.iamRole()).append(",");
        }
        if (this.registrationLimit() != null) {
            sb.append("RegistrationLimit: ").append(this.registrationLimit()).append(",");
        }
        if (this.expirationDate() != null) {
            sb.append("ExpirationDate: ").append(this.expirationDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "DefaultInstanceName": {
                return Optional.of(clazz.cast(this.defaultInstanceName()));
            }
            case "IamRole": {
                return Optional.of(clazz.cast(this.iamRole()));
            }
            case "RegistrationLimit": {
                return Optional.of(clazz.cast(this.registrationLimit()));
            }
            case "ExpirationDate": {
                return Optional.of(clazz.cast(this.expirationDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String defaultInstanceName;
        private String iamRole;
        private Integer registrationLimit;
        private Instant expirationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateActivationRequest model) {
            this.description(model.description);
            this.defaultInstanceName(model.defaultInstanceName);
            this.iamRole(model.iamRole);
            this.registrationLimit(model.registrationLimit);
            this.expirationDate(model.expirationDate);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDefaultInstanceName() {
            return this.defaultInstanceName;
        }

        @Override
        public final Builder defaultInstanceName(String defaultInstanceName) {
            this.defaultInstanceName = defaultInstanceName;
            return this;
        }

        public final void setDefaultInstanceName(String defaultInstanceName) {
            this.defaultInstanceName = defaultInstanceName;
        }

        public final String getIamRole() {
            return this.iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        public final Integer getRegistrationLimit() {
            return this.registrationLimit;
        }

        @Override
        public final Builder registrationLimit(Integer registrationLimit) {
            this.registrationLimit = registrationLimit;
            return this;
        }

        public final void setRegistrationLimit(Integer registrationLimit) {
            this.registrationLimit = registrationLimit;
        }

        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        public CreateActivationRequest build() {
            return new CreateActivationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateActivationRequest> {
        public Builder description(String var1);

        public Builder defaultInstanceName(String var1);

        public Builder iamRole(String var1);

        public Builder registrationLimit(Integer var1);

        public Builder expirationDate(Instant var1);
    }
}

