/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.AssociationDescription;
import software.amazon.awssdk.services.ssm.model.AssociationDescriptionListCopier;
import software.amazon.awssdk.services.ssm.model.FailedCreateAssociation;
import software.amazon.awssdk.services.ssm.model.FailedCreateAssociationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateAssociationBatchResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CreateAssociationBatchResponse> {
    private final List<AssociationDescription> successful;
    private final List<FailedCreateAssociation> failed;

    private CreateAssociationBatchResponse(BuilderImpl builder) {
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    public List<AssociationDescription> successful() {
        return this.successful;
    }

    public List<FailedCreateAssociation> failed() {
        return this.failed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.successful());
        hashCode = 31 * hashCode + Objects.hashCode(this.failed());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssociationBatchResponse)) {
            return false;
        }
        CreateAssociationBatchResponse other = (CreateAssociationBatchResponse)((Object)obj);
        return Objects.equals(this.successful(), other.successful()) && Objects.equals(this.failed(), other.failed());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.successful() != null) {
            sb.append("Successful: ").append(this.successful()).append(",");
        }
        if (this.failed() != null) {
            sb.append("Failed: ").append(this.failed()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Successful": {
                return Optional.of(clazz.cast(this.successful()));
            }
            case "Failed": {
                return Optional.of(clazz.cast(this.failed()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<AssociationDescription> successful;
        private List<FailedCreateAssociation> failed;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssociationBatchResponse model) {
            this.successful(model.successful);
            this.failed(model.failed);
        }

        public final Collection<AssociationDescription.Builder> getSuccessful() {
            return this.successful != null ? (Collection)this.successful.stream().map(AssociationDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successful(Collection<AssociationDescription> successful) {
            this.successful = AssociationDescriptionListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(AssociationDescription ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        public final void setSuccessful(Collection<AssociationDescription.BuilderImpl> successful) {
            this.successful = AssociationDescriptionListCopier.copyFromBuilder(successful);
        }

        public final Collection<FailedCreateAssociation.Builder> getFailed() {
            return this.failed != null ? (Collection)this.failed.stream().map(FailedCreateAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failed(Collection<FailedCreateAssociation> failed) {
            this.failed = FailedCreateAssociationListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(FailedCreateAssociation ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        public final void setFailed(Collection<FailedCreateAssociation.BuilderImpl> failed) {
            this.failed = FailedCreateAssociationListCopier.copyFromBuilder(failed);
        }

        public CreateAssociationBatchResponse build() {
            return new CreateAssociationBatchResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateAssociationBatchResponse> {
        public Builder successful(Collection<AssociationDescription> var1);

        public Builder successful(AssociationDescription ... var1);

        public Builder failed(Collection<FailedCreateAssociation> var1);

        public Builder failed(FailedCreateAssociation ... var1);
    }
}

