/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskIdentity;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskIdentityListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMaintenanceWindowExecutionTasksResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeMaintenanceWindowExecutionTasksResponse> {
    private final List<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities;
    private final String nextToken;

    private DescribeMaintenanceWindowExecutionTasksResponse(BuilderImpl builder) {
        this.windowExecutionTaskIdentities = builder.windowExecutionTaskIdentities;
        this.nextToken = builder.nextToken;
    }

    public List<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities() {
        return this.windowExecutionTaskIdentities;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowExecutionTaskIdentities());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowExecutionTasksResponse)) {
            return false;
        }
        DescribeMaintenanceWindowExecutionTasksResponse other = (DescribeMaintenanceWindowExecutionTasksResponse)((Object)obj);
        return Objects.equals(this.windowExecutionTaskIdentities(), other.windowExecutionTaskIdentities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.windowExecutionTaskIdentities() != null) {
            sb.append("WindowExecutionTaskIdentities: ").append(this.windowExecutionTaskIdentities()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowExecutionTaskIdentities": {
                return Optional.of(clazz.cast(this.windowExecutionTaskIdentities()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowExecutionTasksResponse model) {
            this.windowExecutionTaskIdentities(model.windowExecutionTaskIdentities);
            this.nextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowExecutionTaskIdentity.Builder> getWindowExecutionTaskIdentities() {
            return this.windowExecutionTaskIdentities != null ? (Collection)this.windowExecutionTaskIdentities.stream().map(MaintenanceWindowExecutionTaskIdentity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder windowExecutionTaskIdentities(Collection<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities) {
            this.windowExecutionTaskIdentities = MaintenanceWindowExecutionTaskIdentityListCopier.copy(windowExecutionTaskIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowExecutionTaskIdentities(MaintenanceWindowExecutionTaskIdentity ... windowExecutionTaskIdentities) {
            this.windowExecutionTaskIdentities(Arrays.asList(windowExecutionTaskIdentities));
            return this;
        }

        public final void setWindowExecutionTaskIdentities(Collection<MaintenanceWindowExecutionTaskIdentity.BuilderImpl> windowExecutionTaskIdentities) {
            this.windowExecutionTaskIdentities = MaintenanceWindowExecutionTaskIdentityListCopier.copyFromBuilder(windowExecutionTaskIdentities);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeMaintenanceWindowExecutionTasksResponse build() {
            return new DescribeMaintenanceWindowExecutionTasksResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeMaintenanceWindowExecutionTasksResponse> {
        public Builder windowExecutionTaskIdentities(Collection<MaintenanceWindowExecutionTaskIdentity> var1);

        public Builder windowExecutionTaskIdentities(MaintenanceWindowExecutionTaskIdentity ... var1);

        public Builder nextToken(String var1);
    }
}

