/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTask;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMaintenanceWindowTasksResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeMaintenanceWindowTasksResponse> {
    private final List<MaintenanceWindowTask> tasks;
    private final String nextToken;

    private DescribeMaintenanceWindowTasksResponse(BuilderImpl builder) {
        this.tasks = builder.tasks;
        this.nextToken = builder.nextToken;
    }

    public List<MaintenanceWindowTask> tasks() {
        return this.tasks;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tasks());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowTasksResponse)) {
            return false;
        }
        DescribeMaintenanceWindowTasksResponse other = (DescribeMaintenanceWindowTasksResponse)((Object)obj);
        return Objects.equals(this.tasks(), other.tasks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.tasks() != null) {
            sb.append("Tasks: ").append(this.tasks()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tasks": {
                return Optional.of(clazz.cast(this.tasks()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<MaintenanceWindowTask> tasks;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowTasksResponse model) {
            this.tasks(model.tasks);
            this.nextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowTask.Builder> getTasks() {
            return this.tasks != null ? (Collection)this.tasks.stream().map(MaintenanceWindowTask::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tasks(Collection<MaintenanceWindowTask> tasks) {
            this.tasks = MaintenanceWindowTaskListCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(MaintenanceWindowTask ... tasks) {
            this.tasks(Arrays.asList(tasks));
            return this;
        }

        public final void setTasks(Collection<MaintenanceWindowTask.BuilderImpl> tasks) {
            this.tasks = MaintenanceWindowTaskListCopier.copyFromBuilder(tasks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeMaintenanceWindowTasksResponse build() {
            return new DescribeMaintenanceWindowTasksResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeMaintenanceWindowTasksResponse> {
        public Builder tasks(Collection<MaintenanceWindowTask> var1);

        public Builder tasks(MaintenanceWindowTask ... var1);

        public Builder nextToken(String var1);
    }
}

