/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetParameterHistoryRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetParameterHistoryRequest> {
    private final String name;
    private final Boolean withDecryption;
    private final Integer maxResults;
    private final String nextToken;

    private GetParameterHistoryRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.withDecryption = builder.withDecryption;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public String name() {
        return this.name;
    }

    public Boolean withDecryption() {
        return this.withDecryption;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.withDecryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParameterHistoryRequest)) {
            return false;
        }
        GetParameterHistoryRequest other = (GetParameterHistoryRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.withDecryption(), other.withDecryption()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.withDecryption() != null) {
            sb.append("WithDecryption: ").append(this.withDecryption()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "WithDecryption": {
                return Optional.of(clazz.cast(this.withDecryption()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Boolean withDecryption;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParameterHistoryRequest model) {
            this.name(model.name);
            this.withDecryption(model.withDecryption);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getWithDecryption() {
            return this.withDecryption;
        }

        @Override
        public final Builder withDecryption(Boolean withDecryption) {
            this.withDecryption = withDecryption;
            return this;
        }

        public final void setWithDecryption(Boolean withDecryption) {
            this.withDecryption = withDecryption;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public GetParameterHistoryRequest build() {
            return new GetParameterHistoryRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetParameterHistoryRequest> {
        public Builder name(String var1);

        public Builder withDecryption(Boolean var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

