/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationOutputUrl;
import software.amazon.awssdk.services.ssm.transform.InstanceAssociationStatusInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceAssociationStatusInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceAssociationStatusInfo> {
    private final String associationId;
    private final String name;
    private final String documentVersion;
    private final String associationVersion;
    private final String instanceId;
    private final Instant executionDate;
    private final String status;
    private final String detailedStatus;
    private final String executionSummary;
    private final String errorCode;
    private final InstanceAssociationOutputUrl outputUrl;
    private final String associationName;

    private InstanceAssociationStatusInfo(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.name = builder.name;
        this.documentVersion = builder.documentVersion;
        this.associationVersion = builder.associationVersion;
        this.instanceId = builder.instanceId;
        this.executionDate = builder.executionDate;
        this.status = builder.status;
        this.detailedStatus = builder.detailedStatus;
        this.executionSummary = builder.executionSummary;
        this.errorCode = builder.errorCode;
        this.outputUrl = builder.outputUrl;
        this.associationName = builder.associationName;
    }

    public String associationId() {
        return this.associationId;
    }

    public String name() {
        return this.name;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public String associationVersion() {
        return this.associationVersion;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Instant executionDate() {
        return this.executionDate;
    }

    public String status() {
        return this.status;
    }

    public String detailedStatus() {
        return this.detailedStatus;
    }

    public String executionSummary() {
        return this.executionSummary;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public InstanceAssociationOutputUrl outputUrl() {
        return this.outputUrl;
    }

    public String associationName() {
        return this.associationName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.detailedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAssociationStatusInfo)) {
            return false;
        }
        InstanceAssociationStatusInfo other = (InstanceAssociationStatusInfo)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.associationVersion(), other.associationVersion()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.executionDate(), other.executionDate()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.detailedStatus(), other.detailedStatus()) && Objects.equals(this.executionSummary(), other.executionSummary()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.outputUrl(), other.outputUrl()) && Objects.equals(this.associationName(), other.associationName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.associationId() != null) {
            sb.append("AssociationId: ").append(this.associationId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.documentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.documentVersion()).append(",");
        }
        if (this.associationVersion() != null) {
            sb.append("AssociationVersion: ").append(this.associationVersion()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.executionDate() != null) {
            sb.append("ExecutionDate: ").append(this.executionDate()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.detailedStatus() != null) {
            sb.append("DetailedStatus: ").append(this.detailedStatus()).append(",");
        }
        if (this.executionSummary() != null) {
            sb.append("ExecutionSummary: ").append(this.executionSummary()).append(",");
        }
        if (this.errorCode() != null) {
            sb.append("ErrorCode: ").append(this.errorCode()).append(",");
        }
        if (this.outputUrl() != null) {
            sb.append("OutputUrl: ").append(this.outputUrl()).append(",");
        }
        if (this.associationName() != null) {
            sb.append("AssociationName: ").append(this.associationName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.of(clazz.cast(this.associationId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "DocumentVersion": {
                return Optional.of(clazz.cast(this.documentVersion()));
            }
            case "AssociationVersion": {
                return Optional.of(clazz.cast(this.associationVersion()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "ExecutionDate": {
                return Optional.of(clazz.cast(this.executionDate()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "DetailedStatus": {
                return Optional.of(clazz.cast(this.detailedStatus()));
            }
            case "ExecutionSummary": {
                return Optional.of(clazz.cast(this.executionSummary()));
            }
            case "ErrorCode": {
                return Optional.of(clazz.cast(this.errorCode()));
            }
            case "OutputUrl": {
                return Optional.of(clazz.cast(this.outputUrl()));
            }
            case "AssociationName": {
                return Optional.of(clazz.cast(this.associationName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceAssociationStatusInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String name;
        private String documentVersion;
        private String associationVersion;
        private String instanceId;
        private Instant executionDate;
        private String status;
        private String detailedStatus;
        private String executionSummary;
        private String errorCode;
        private InstanceAssociationOutputUrl outputUrl;
        private String associationName;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAssociationStatusInfo model) {
            this.associationId(model.associationId);
            this.name(model.name);
            this.documentVersion(model.documentVersion);
            this.associationVersion(model.associationVersion);
            this.instanceId(model.instanceId);
            this.executionDate(model.executionDate);
            this.status(model.status);
            this.detailedStatus(model.detailedStatus);
            this.executionSummary(model.executionSummary);
            this.errorCode(model.errorCode);
            this.outputUrl(model.outputUrl);
            this.associationName(model.associationName);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getAssociationVersion() {
            return this.associationVersion;
        }

        @Override
        public final Builder associationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
            return this;
        }

        public final void setAssociationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Instant getExecutionDate() {
            return this.executionDate;
        }

        @Override
        public final Builder executionDate(Instant executionDate) {
            this.executionDate = executionDate;
            return this;
        }

        public final void setExecutionDate(Instant executionDate) {
            this.executionDate = executionDate;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDetailedStatus() {
            return this.detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        public final String getExecutionSummary() {
            return this.executionSummary;
        }

        @Override
        public final Builder executionSummary(String executionSummary) {
            this.executionSummary = executionSummary;
            return this;
        }

        public final void setExecutionSummary(String executionSummary) {
            this.executionSummary = executionSummary;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final InstanceAssociationOutputUrl.Builder getOutputUrl() {
            return this.outputUrl != null ? this.outputUrl.toBuilder() : null;
        }

        @Override
        public final Builder outputUrl(InstanceAssociationOutputUrl outputUrl) {
            this.outputUrl = outputUrl;
            return this;
        }

        public final void setOutputUrl(InstanceAssociationOutputUrl.BuilderImpl outputUrl) {
            this.outputUrl = outputUrl != null ? outputUrl.build() : null;
        }

        public final String getAssociationName() {
            return this.associationName;
        }

        @Override
        public final Builder associationName(String associationName) {
            this.associationName = associationName;
            return this;
        }

        public final void setAssociationName(String associationName) {
            this.associationName = associationName;
        }

        public InstanceAssociationStatusInfo build() {
            return new InstanceAssociationStatusInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceAssociationStatusInfo> {
        public Builder associationId(String var1);

        public Builder name(String var1);

        public Builder documentVersion(String var1);

        public Builder associationVersion(String var1);

        public Builder instanceId(String var1);

        public Builder executionDate(Instant var1);

        public Builder status(String var1);

        public Builder detailedStatus(String var1);

        public Builder executionSummary(String var1);

        public Builder errorCode(String var1);

        public Builder outputUrl(InstanceAssociationOutputUrl var1);

        default public Builder outputUrl(Consumer<InstanceAssociationOutputUrl.Builder> outputUrl) {
            return this.outputUrl((InstanceAssociationOutputUrl)((InstanceAssociationOutputUrl.Builder)InstanceAssociationOutputUrl.builder().apply(outputUrl)).build());
        }

        public Builder associationName(String var1);
    }
}

